"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGenAIConnectors = useGenAIConnectors;
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to fetch available GenAI connectors.
 */
function useGenAIConnectors() {
  const {
    services: {
      inference
    }
  } = (0, _use_kibana.useKibana)();
  const {
    value: connectors = [],
    loading
  } = (0, _useAsync.default)(async () => {
    if (!inference) {
      return [];
    }
    return inference.getConnectors();
  }, [inference]);
  return {
    connectors,
    hasConnectors: connectors.length > 0,
    loading
  };
}