"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AiInsight = AiInsight;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _use_kibana = require("../../hooks/use_kibana");
var _use_license = require("../../hooks/use_license");
var _use_genai_connectors = require("../../hooks/use_genai_connectors");
var _start_conversation_button = require("./start_conversation_button");
var _ai_insight_error_banner = require("./ai_insight_error_banner");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_agent_builder/public/components/ai_insight/ai_insight.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AiInsight({
  title,
  fetchInsight,
  buildAttachments
}) {
  var _application$capabili;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(undefined);
  const [summary, setSummary] = (0, _react.useState)('');
  const [context, setContext] = (0, _react.useState)('');
  const {
    services: {
      onechat,
      application
    }
  } = (0, _use_kibana.useKibana)();
  const {
    getLicense
  } = (0, _use_license.useLicense)();
  const license = getLicense();
  const [chatExperience] = (0, _public.useUiSetting$)(_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE);
  const isAgentChatExperienceEnabled = chatExperience === _aiAssistantCommon.AIChatExperience.Agent;
  const {
    hasConnectors
  } = (0, _use_genai_connectors.useGenAIConnectors)();
  const hasEnterpriseLicense = license === null || license === void 0 ? void 0 : license.hasAtLeast('enterprise');
  const hasAgentBuilderAccess = (application === null || application === void 0 ? void 0 : (_application$capabili = application.capabilities.agentBuilder) === null || _application$capabili === void 0 ? void 0 : _application$capabili.show) === true;
  const handleFetchInsight = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    setError(undefined);
    try {
      const response = await fetchInsight();
      setSummary(response.summary);
      setContext(response.context);
    } catch (e) {
      setError(e instanceof Error ? e.message : 'Failed to load AI insight');
    } finally {
      setIsLoading(false);
    }
  }, [fetchInsight]);
  const handleStartConversation = (0, _react.useCallback)(() => {
    if (!(onechat !== null && onechat !== void 0 && onechat.openConversationFlyout)) return;
    onechat.openConversationFlyout({
      newConversation: true,
      agentId: _constants.OBSERVABILITY_AGENT_ID,
      attachments: buildAttachments(summary, context)
    });
  }, [onechat, buildAttachments, summary, context]);
  if (!onechat || !hasConnectors || !isAgentChatExperienceEnabled || !hasAgentBuilderAccess || !hasEnterpriseLicense) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "agentBuilderAiInsight",
    arrowProps: {
      css: {
        alignSelf: 'flex-start'
      }
    },
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      responsive: false,
      gutterSize: "m",
      alignItems: "flexStart",
      "data-test-subj": "agentBuilderAiInsight",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "sparkles",
      color: euiTheme.colors.primary,
      style: {
        marginTop: 6
      },
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: {
        marginTop: 2,
        marginBottom: 1
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 17
      }
    }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      css: {
        color: euiTheme.colors.textSubdued
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.observabilityAgentBuilder.aiInsight.description', {
      defaultMessage: 'Get helpful insights from our Elastic AI Agent'
    }))))),
    isLoading: false,
    isDisabled: false,
    forceState: isOpen ? 'open' : 'closed',
    onToggle: open => {
      setIsOpen(open);
      if (open && !error && !summary && !isLoading) {
        handleFetchInsight();
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  }) : error ? /*#__PURE__*/_react.default.createElement(_ai_insight_error_banner.AiInsightErrorBanner, {
    error: error,
    onRetry: handleFetchInsight,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    textSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 13
    }
  }, summary)), !isLoading && Boolean(summary && summary.trim()) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_start_conversation_button.StartConversationButton, {
    onClick: handleStartConversation,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 17
    }
  })))) : null));
}