"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenuPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/navigation/public/top_nav_menu_beta/top_nav_menu_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TopNavMenuPopover = ({
  items,
  anchorElement,
  tooltipContent,
  tooltipTitle,
  isOpen,
  popoverWidth,
  primaryActionItem,
  secondaryActionItem,
  anchorPosition,
  testId,
  onClose
}) => {
  const panels = (0, _react.useMemo)(() => (0, _utils.getPopoverPanels)({
    items,
    primaryActionItem,
    secondaryActionItem
  }), [items, primaryActionItem, secondaryActionItem]);
  if (panels.length === 0) {
    return null;
  }
  const {
    content,
    title
  } = (0, _utils.getTooltip)({
    tooltipContent,
    tooltipTitle
  });
  const showTooltip = Boolean(content || title);
  const button = showTooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: content,
    title: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, anchorElement) : anchorElement;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": testId || 'top-nav-menu-popover',
    button: button,
    isOpen: isOpen,
    closePopover: onClose,
    panelPaddingSize: "none",
    hasArrow: false,
    anchorPosition: anchorPosition || 'upLeft',
    panelStyle: {
      width: popoverWidth
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }));
};
exports.TopNavMenuPopover = TopNavMenuPopover;