"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchClusters = void 0;
exports.formatCluster = formatCluster;
exports.formatClusters = formatClusters;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatClusters(clusters) {
  return clusters.map(formatCluster);
}
function formatCluster(cluster) {
  if (cluster.cluster_uuid === _constants.STANDALONE_CLUSTER_CLUSTER_UUID) {
    cluster.cluster_name = 'Standalone Cluster';
  }
  return cluster;
}
const fetchClusters = async ({
  clusterUuid,
  timeRange,
  fetch,
  ccs,
  codePaths
}) => {
  let url = '../api/monitoring/v1/clusters';
  if (clusterUuid) {
    url += `/${clusterUuid}`;
  }
  const response = await fetch(url, {
    method: 'POST',
    body: JSON.stringify({
      ccs,
      timeRange,
      codePaths
    })
  });
  return formatClusters(response);
};
exports.fetchClusters = fetchClusters;