"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchPanel = ElasticsearchPanel;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _lodash = require("lodash");
var _format_number = require("../../../lib/format_number");
var _helpers = require("./helpers");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reason = require("../../logs/reason");
var _tooltip = require("../../setup_mode/tooltip");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _constants = require("../../../../common/constants");
var _badge = require("../../../alerts/badge");
var _should_show_alert_badge = require("../../../alerts/lib/should_show_alert_badge");
var _enums = require("../../../../common/enums");
var _setup_mode = require("../../../lib/setup_mode");
var _setup_mode_context = require("../../setup_mode/setup_mode_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/cluster/overview/elasticsearch_panel.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const calculateShards = shards => {
  const total = (0, _lodash.get)(shards, 'total', 0);
  let primaries = (0, _lodash.get)(shards, 'primaries', 'N/A');
  let replicas = 'N/A';

  // we subtract primaries from total to get replica count, so if we don't know primaries, then
  //  we cannot know replicas (because we'd be showing the wrong number!)
  if (primaries !== 'N/A') {
    replicas = (0, _format_number.formatNumber)(total - primaries, 'int_commas');
    primaries = (0, _format_number.formatNumber)(primaries, 'int_commas');
  }
  return {
    primaries,
    replicas
  };
};
const formatDateLocal = input => _momentTimezone.default.tz(input, _momentTimezone.default.tz.guess()).format('LL');
function getBadgeColorFromLogLevel(level) {
  switch (level) {
    case 'warn':
      return 'warning';
    case 'debug':
      return 'hollow';
    case 'info':
      return 'default';
    case 'error':
      return 'danger';
  }
}
function renderLogs(props) {
  if (!props.logs.enabled) {
    return /*#__PURE__*/_react.default.createElement(_reason.Reason, {
      reason: props.logs.reason,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, props.logs.types.map((log, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: index,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.logsPanel.logTypeTitle",
    defaultMessage: "{type}",
    values: {
      type: (0, _lodash.capitalize)(log.type)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, renderLog(log)))), props.logs.types.length === 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.logsPanel.noLogsFound",
    defaultMessage: "No logs found.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }) : null);
}
const logLevelText = {
  info: _i18n.i18n.translate('xpack.monitoring.cluster.overview.esPanel.infoLogsTooltipText', {
    defaultMessage: 'The number of information logs'
  }),
  warn: _i18n.i18n.translate('xpack.monitoring.cluster.overview.esPanel.warnLogsTooltipText', {
    defaultMessage: 'The number of warning logs'
  }),
  debug: _i18n.i18n.translate('xpack.monitoring.cluster.overview.esPanel.debugLogsTooltipText', {
    defaultMessage: 'The number of debug logs'
  }),
  error: _i18n.i18n.translate('xpack.monitoring.cluster.overview.esPanel.errorLogsTooltipText', {
    defaultMessage: 'The number of error logs'
  }),
  fatal: _i18n.i18n.translate('xpack.monitoring.cluster.overview.esPanel.fatalLogsTooltipText', {
    defaultMessage: 'The number of fatal logs'
  }),
  unknown: _i18n.i18n.translate('xpack.monitoring.cluster.overview.esPanel.unknownLogsTooltipText', {
    defaultMessage: 'Unknown'
  })
};
function renderLog(log) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    responsive: false,
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 5
    }
  }, log.levels.map((level, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: index,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: logLevelText[level.level] || logLevelText.unknown,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: getBadgeColorFromLogLevel(level.level),
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 13
    }
  }, (0, _format_number.formatNumber)(level.count, 'int_commas'))))));
}
const OVERVIEW_PANEL_RULES = [_constants.RULE_CLUSTER_HEALTH, _constants.RULE_LICENSE_EXPIRATION, _constants.RULE_CCR_READ_EXCEPTIONS];
const NODES_PANEL_RULES = [_constants.RULE_CPU_USAGE, _constants.RULE_DISK_USAGE, _constants.RULE_THREAD_POOL_SEARCH_REJECTIONS, _constants.RULE_THREAD_POOL_WRITE_REJECTIONS, _constants.RULE_MEMORY_USAGE, _constants.RULE_NODES_CHANGED, _constants.RULE_ELASTICSEARCH_VERSION_MISMATCH, _constants.RULE_MISSING_MONITORING_DATA];
const INDICES_PANEL_RULES = [_constants.RULE_LARGE_SHARD_SIZE];
function ElasticsearchPanel(props) {
  const clusterStats = props.cluster_stats || {};
  const nodes = clusterStats.nodes;
  const indices = clusterStats.indices;
  const setupMode = props.setupMode;
  const alerts = props.alerts;
  const setupModeContext = _react.default.useContext(_setup_mode_context.SetupModeContext);
  const goToElasticsearch = () => (0, _get_safe_for_external_link.getSafeForExternalLink)('#/elasticsearch');
  const goToNodes = () => (0, _get_safe_for_external_link.getSafeForExternalLink)('#/elasticsearch/nodes');
  const goToIndices = () => (0, _get_safe_for_external_link.getSafeForExternalLink)('#/elasticsearch/indices');
  const {
    primaries,
    replicas
  } = calculateShards((0, _lodash.get)(props, 'cluster_stats.indices.shards', {}));
  const setupModeData = (0, _lodash.get)(setupMode.data, 'elasticsearch');
  const setupModeMetricbeatMigrationTooltip = (0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration) ? /*#__PURE__*/_react.default.createElement(_tooltip.SetupModeTooltip, {
    setupModeData: setupModeData,
    productName: _constants.ELASTICSEARCH_SYSTEM_ID,
    badgeClickLink: goToNodes(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 5
    }
  }) : null;
  const showMlJobs = () => {
    // if license doesn't support ML, then `ml === null`
    if (props.ml) {
      const gotoURL = (0, _get_safe_for_external_link.getSafeForExternalLink)('#/elasticsearch/ml_jobs');
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
        className: "eui-textBreakWord",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 211,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_helpers.DisabledIfNoDataAndInSetupModeLink, {
        setupModeEnabled: setupMode.enabled,
        setupModeData: setupModeData,
        href: gotoURL,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 212,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.cluster.overview.esPanel.jobsLabel",
        defaultMessage: "Machine learning jobs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 15
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
        "data-test-subj": "esMlJobs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 223,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_helpers.DisabledIfNoDataAndInSetupModeLink, {
        setupModeEnabled: setupMode.enabled,
        setupModeData: setupModeData,
        href: gotoURL,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 224,
          columnNumber: 13
        }
      }, props.ml.jobs)));
    }
    return null;
  };
  const showLicense = () => {
    if (!props.showLicenseExpiration) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      className: "eui-textBreakWord",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.cluster.overview.esPanel.licenseLabel",
      defaultMessage: "License",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "esLicenseType",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: (0, _get_safe_for_external_link.getSafeForExternalLink)('#/license'),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 15
      }
    }, (0, _lodash.capitalize)(props.license.type))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 257,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 15
      }
    }, props.license.expiry_date_in_millis === undefined ? '' : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.cluster.overview.esPanel.expireDateText",
      defaultMessage: "expires on {expiryDate}",
      values: {
        expiryDate: formatDateLocal(props.license.expiry_date_in_millis)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 19
      }
    }))))));
  };
  const statusColorMap = {
    green: 'success',
    yellow: 'warning',
    red: 'danger'
  };
  let nodesAlertStatus = null;
  if ((0, _should_show_alert_badge.shouldShowAlertBadge)(alerts, NODES_PANEL_RULES, setupModeContext)) {
    const alertsList = NODES_PANEL_RULES.map(alertType => alerts[alertType]);
    nodesAlertStatus = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 288,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_badge.AlertsBadge, {
      alerts: alertsList,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 289,
        columnNumber: 9
      }
    }));
  }
  let overviewAlertStatus = null;
  if ((0, _should_show_alert_badge.shouldShowAlertBadge)(alerts, OVERVIEW_PANEL_RULES, setupModeContext)) {
    const alertsList = OVERVIEW_PANEL_RULES.map(alertType => alerts[alertType]);
    overviewAlertStatus = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_badge.AlertsBadge, {
      alerts: alertsList,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 9
      }
    }));
  }
  let indicesAlertStatus = null;
  if ((0, _should_show_alert_badge.shouldShowAlertBadge)(alerts, INDICES_PANEL_RULES, setupModeContext)) {
    const alertsList = INDICES_PANEL_RULES.map(alertType => alerts[alertType]);
    indicesAlertStatus = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 308,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_badge.AlertsBadge, {
      alerts: alertsList,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 309,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_helpers.ClusterItemContainer, (0, _extends2.default)({}, props, {
    url: "elasticsearch",
    title: "Elasticsearch",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 4,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers.DisabledIfNoDataAndInSetupModeLink, {
    setupModeEnabled: setupMode.enabled,
    setupModeData: setupModeData,
    href: goToElasticsearch(),
    "aria-label": _i18n.i18n.translate('xpack.monitoring.cluster.overview.esPanel.overviewLinkAriaLabel', {
      defaultMessage: 'Elasticsearch Overview'
    }),
    "data-test-subj": "esOverview",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.esPanel.overviewLinkLabel",
    defaultMessage: "Overview",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 23
    }
  }))))), overviewAlertStatus), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.esPanel.healthLabel",
    defaultMessage: "Health",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: statusColorMap[clusterStats.status],
    "data-test-subj": "statusIcon",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers.HealthLabel, {
    status: clusterStats.status,
    product: 'es',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.esPanel.versionLabel",
    defaultMessage: "Version",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "esVersion",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 15
    }
  }, props.version || _i18n.i18n.translate('xpack.monitoring.cluster.overview.esPanel.versionNotAvailableDescription', {
    defaultMessage: 'N/A'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.esPanel.uptimeLabel",
    defaultMessage: "Uptime",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "esUptime",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 379,
      columnNumber: 15
    }
  }, (0, _format_number.formatNumber)((0, _lodash.get)(nodes, 'jvm.max_uptime_in_millis'), 'time_since')), showMlJobs(), showLicense()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 393,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "esNumberOfNodes",
    href: goToNodes(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 394,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.esPanel.nodesTotalLinkLabel",
    defaultMessage: "Nodes: {nodesTotal}",
    values: {
      nodesTotal: (0, _format_number.formatNumber)((0, _lodash.get)(nodes, 'count.total'), 'int_commas')
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 395,
      columnNumber: 23
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 406,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 17
    }
  }, setupModeMetricbeatMigrationTooltip, nodesAlertStatus))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 413,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 414,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 415,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.esPanel.diskAvailableLabel",
    defaultMessage: "Disk Available",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 416,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "esDiskAvailable",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers.BytesPercentageUsage, {
    usedBytes: (0, _lodash.get)(nodes, 'fs.available.bytes', (0, _lodash.get)(nodes, 'fs.available_in_bytes')),
    maxBytes: (0, _lodash.get)(nodes, 'fs.total.bytes', (0, _lodash.get)(nodes, 'fs.total_in_bytes')),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 427,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.esPanel.jvmHeapLabel",
    defaultMessage: "{javaVirtualMachine} Heap",
    values: {
      javaVirtualMachine: 'JVM'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 428,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "esJvmHeap",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers.BytesPercentageUsage, {
    usedBytes: (0, _lodash.get)(nodes, 'jvm.mem.heap.used.bytes', (0, _lodash.get)(nodes, 'jvm.mem.heap_used_in_bytes')),
    maxBytes: (0, _lodash.get)(nodes, 'jvm.mem.heap.max.bytes', (0, _lodash.get)(nodes, 'jvm.mem.heap_max_in_bytes')),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 435,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 452,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 453,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 454,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 455,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 456,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 457,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers.DisabledIfNoDataAndInSetupModeLink, {
    setupModeEnabled: setupMode.enabled,
    setupModeData: setupModeData,
    href: goToIndices(),
    "data-test-subj": "esNumberOfIndices",
    "aria-label": _i18n.i18n.translate('xpack.monitoring.cluster.overview.esPanel.indicesCountLinkAriaLabel', {
      defaultMessage: 'Elasticsearch Indices: {indicesCount}',
      values: {
        indicesCount: (0, _format_number.formatNumber)((0, _lodash.get)(indices, 'count'), 'int_commas')
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 458,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.esPanel.indicesCountLinkLabel",
    defaultMessage: "Indices: {indicesCount}",
    values: {
      indicesCount: (0, _format_number.formatNumber)((0, _lodash.get)(indices, 'count'), 'int_commas')
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 473,
      columnNumber: 23
    }
  }))))), indicesAlertStatus), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 484,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 485,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 486,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.esPanel.documentsLabel",
    defaultMessage: "Documents",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 487,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "esDocumentsCount",
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 492,
      columnNumber: 15
    }
  }, (0, _format_number.formatNumber)((0, _lodash.get)(indices, 'docs.total', (0, _lodash.get)(indices, 'docs.count')), 'int_commas')), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 499,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.esPanel.diskUsageLabel",
    defaultMessage: "Disk Usage",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 500,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "esDiskUsage",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 505,
      columnNumber: 15
    }
  }, (0, _format_number.formatNumber)((0, _lodash.get)(indices, 'store.size.bytes', (0, _lodash.get)(indices, 'store.size_in_bytes')), 'byte')), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 512,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.esPanel.primaryShardsLabel",
    defaultMessage: "Primary Shards",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 513,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "esPrimaryShards",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 518,
      columnNumber: 15
    }
  }, primaries), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 522,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.esPanel.replicaShardsLabel",
    defaultMessage: "Replica Shards",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 523,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "esReplicaShards",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 528,
      columnNumber: 15
    }
  }, replicas)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 535,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 536,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 537,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 538,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers.DisabledIfNoDataAndInSetupModeLink, {
    setupModeEnabled: setupMode.enabled,
    setupModeData: setupModeData,
    href: goToElasticsearch(),
    "aria-label": _i18n.i18n.translate('xpack.monitoring.cluster.overview.esPanel.logsLinkAriaLabel', {
      defaultMessage: 'Elasticsearch Logs'
    }),
    "data-test-subj": "esLogs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 539,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.esPanel.logsLinkLabel",
    defaultMessage: "Logs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 551,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 558,
      columnNumber: 13
    }
  }), renderLogs(props)))));
}