"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Enabler = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// From x-pack/platform/plugins/private/monitoring/public/lib/elasticsearch_settings/enabler.js
class Enabler {
  constructor(http, updateModel) {
    (0, _defineProperty2.default)(this, "http", void 0);
    (0, _defineProperty2.default)(this, "updateModel", void 0);
    this.http = http;
    this.updateModel = updateModel;
  }
  async enableCollectionInterval() {
    try {
      this.updateModel({
        isCollectionIntervalUpdating: true
      });
      await this.http.fetch('../api/monitoring/v1/elasticsearch_settings/set/collection_interval', {
        method: 'PUT'
      });
      this.updateModel({
        isCollectionIntervalUpdated: true,
        isCollectionIntervalUpdating: false
      });
    } catch (err) {
      this.updateModel({
        errors: err.data,
        isCollectionIntervalUpdated: false,
        isCollectionIntervalUpdating: false
      });
    }
  }
  async enableCollectionEnabled() {
    try {
      this.updateModel({
        isCollectionEnabledUpdating: true
      });
      await this.http.fetch('../api/monitoring/v1/elasticsearch_settings/set/collection_enabled', {
        method: 'PUT'
      });
      this.updateModel({
        isCollectionEnabledUpdated: true,
        isCollectionEnabledUpdating: false
      });
    } catch (err) {
      this.updateModel({
        errors: err.data,
        isCollectionEnabledUpdated: false,
        isCollectionEnabledUpdating: false
      });
    }
  }
}
exports.Enabler = Enabler;