"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildConsoleTheme = void 0;
var _eui = require("@elastic/eui");
var _code_editor = require("../../code_editor");
var _theme = require("../../common/theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const buildRuleGroup = (0, _theme.themeRuleGroupBuilderFactory)();
const getConsoleColorConfig = themeVars => {
  return {
    background: themeVars.colors.backgroundBaseSubdued,
    booleanTextColor: themeVars.colors.textPrimary,
    methodTextColor: themeVars.colors.textAccent,
    urlTextColor: themeVars.colors.textAccentSecondary,
    defaultStatusBackgroundColor: themeVars.colors.backgroundLightAccentSecondary,
    successStatusBackgroundColor: themeVars.colors.backgroundLightSuccess,
    primaryStatusBackgroundColor: themeVars.colors.backgroundLightPrimary,
    warningStatusBackgroundColor: themeVars.colors.backgroundLightWarning,
    dangerStatusBackgroundColor: themeVars.colors.backgroundLightDanger
  };
};
const buildConsoleTheme = ({
  colorMode,
  euiTheme,
  ...rest
}) => {
  const consoleColors = getConsoleColorConfig(euiTheme);
  const themeBase = _code_editor.defaultThemesResolvers[_code_editor.CODE_EDITOR_DEFAULT_THEME_ID]({
    colorMode,
    euiTheme,
    ...rest
  });
  return {
    ...themeBase,
    rules: [...themeBase.rules, ...buildRuleGroup(['string-literal', 'multi-string', 'punctuation.end-triple-quote'], (0, _eui.makeHighContrastColor)(euiTheme.colors.textDanger)(consoleColors.background)), ...buildRuleGroup(['constant.language.boolean'], (0, _eui.makeHighContrastColor)(consoleColors.booleanTextColor)(consoleColors.background)), ...buildRuleGroup(['constant.numeric'], (0, _eui.makeHighContrastColor)(euiTheme.colors.textAccent)(consoleColors.background)), ...buildRuleGroup(['comment.default'], (0, _eui.makeHighContrastColor)(euiTheme.colors.textPrimary)(consoleColors.defaultStatusBackgroundColor)), ...buildRuleGroup(['comment.success'], (0, _eui.makeHighContrastColor)(euiTheme.colors.textSuccess)(consoleColors.successStatusBackgroundColor)), ...buildRuleGroup(['comment.primary'], (0, _eui.makeHighContrastColor)(euiTheme.colors.textPrimary)(consoleColors.primaryStatusBackgroundColor)), ...buildRuleGroup(['comment.warning'], (0, _eui.makeHighContrastColor)(euiTheme.colors.textWarning)(consoleColors.warningStatusBackgroundColor)), ...buildRuleGroup(['comment.danger'], (0, _eui.makeHighContrastColor)(euiTheme.colors.textDanger)(consoleColors.dangerStatusBackgroundColor)), ...buildRuleGroup(['status.default'], (0, _eui.makeHighContrastColor)(euiTheme.colors.textPrimary)(consoleColors.defaultStatusBackgroundColor), true), ...buildRuleGroup(['status.success'], (0, _eui.makeHighContrastColor)(euiTheme.colors.textSuccess)(consoleColors.successStatusBackgroundColor), true), ...buildRuleGroup(['status.primary'], (0, _eui.makeHighContrastColor)(euiTheme.colors.textPrimary)(consoleColors.primaryStatusBackgroundColor), true), ...buildRuleGroup(['status.warning'], (0, _eui.makeHighContrastColor)(euiTheme.colors.textWarning)(consoleColors.warningStatusBackgroundColor), true), ...buildRuleGroup(['status.danger'], (0, _eui.makeHighContrastColor)(euiTheme.colors.textDanger)(consoleColors.dangerStatusBackgroundColor), true), ...buildRuleGroup(['method'], (0, _eui.makeHighContrastColor)(consoleColors.methodTextColor)(consoleColors.background)), ...buildRuleGroup(['url'], (0, _eui.makeHighContrastColor)(consoleColors.urlTextColor)(consoleColors.background))],
    colors: {
      ...themeBase.colors,
      'editorLineNumber.foreground': euiTheme.colors.textPrimary
    }
  };
};
exports.buildConsoleTheme = buildConsoleTheme;