"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getParsedRequestsProvider = exports.ConsoleOutputLang = exports.ConsoleLang = exports.CONSOLE_TRIGGER_CHARS = exports.CONSOLE_THEME_ID = exports.CONSOLE_OUTPUT_THEME_ID = void 0;
var _esqlAst = require("@kbn/esql-ast");
var _console_errors_provider = require("./console_errors_provider");
var _console_worker_proxy = require("./console_worker_proxy");
var _constants = require("./constants");
var _esql = require("../esql");
var _suggestions = require("../esql/lib/converters/suggestions");
var _console_parsed_requests_provider = require("./console_parsed_requests_provider");
var _theme = require("./theme");
var _utils = require("./utils");
var _lexer_rules = require("./lexer_rules");
var _folding_range_provider = require("./folding_range_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const workerProxyService = new _console_worker_proxy.ConsoleWorkerProxyService();
const CONSOLE_TRIGGER_CHARS = exports.CONSOLE_TRIGGER_CHARS = ['/', '.', '_', ',', '?', '=', '&', '"'];

/**
 * @description This language definition is used for the console input panel
 */
const ConsoleLang = exports.ConsoleLang = {
  ID: _constants.CONSOLE_LANG_ID,
  lexerRules: _lexer_rules.lexerRules,
  languageConfiguration: _lexer_rules.languageConfiguration,
  foldingRangeProvider: _folding_range_provider.foldingRangeProvider,
  onLanguage: () => {
    workerProxyService.setup();
    (0, _console_errors_provider.setupConsoleErrorsProvider)(workerProxyService);
  },
  languageThemeResolver: _theme.buildConsoleTheme,
  getSuggestionProvider: (esqlCallbacks, actionsProvider) => {
    return {
      // force suggestions when these characters are used
      triggerCharacters: [...CONSOLE_TRIGGER_CHARS, ..._esql.ESQL_AUTOCOMPLETE_TRIGGER_CHARS],
      provideCompletionItems: async (model, position, context) => {
        const fullText = model.getValue();
        const cursorOffset = model.getOffsetAt(position);
        const textBeforeCursor = fullText.slice(0, cursorOffset);
        const {
          insideTripleQuotes,
          insideEsqlQuery,
          esqlQueryIndex
        } = (0, _utils.checkForTripleQuotesAndEsqlQuery)(textBeforeCursor);
        if (esqlCallbacks && insideEsqlQuery) {
          const queryText = textBeforeCursor.slice(esqlQueryIndex, cursorOffset);
          const unescapedQuery = (0, _utils.unescapeInvalidChars)(queryText);
          const esqlSuggestions = await (0, _esqlAst.suggest)(unescapedQuery, unescapedQuery.length, esqlCallbacks);
          return (0, _suggestions.wrapAsMonacoSuggestions)(esqlSuggestions, queryText, false, !insideTripleQuotes, true);
        } else if (actionsProvider.current) {
          var _actionsProvider$curr;
          return (_actionsProvider$curr = actionsProvider.current) === null || _actionsProvider$curr === void 0 ? void 0 : _actionsProvider$curr.provideCompletionItems(model, position, context);
        }
        return {
          suggestions: []
        };
      }
    };
  }
};

/**
 * @description This language definition is used for the console output panel
 */
const ConsoleOutputLang = exports.ConsoleOutputLang = {
  ID: _constants.CONSOLE_OUTPUT_LANG_ID,
  lexerRules: _lexer_rules.consoleOutputLexerRules,
  languageConfiguration: _lexer_rules.consoleOutputLanguageConfiguration,
  foldingRangeProvider: _folding_range_provider.foldingRangeProvider
};

// Theme id is the same as lang id, as we register only one theme resolver that's color mode aware
const CONSOLE_THEME_ID = exports.CONSOLE_THEME_ID = _constants.CONSOLE_LANG_ID;

// console output theme is the same as console theme
const CONSOLE_OUTPUT_THEME_ID = exports.CONSOLE_OUTPUT_THEME_ID = CONSOLE_THEME_ID;
const getParsedRequestsProvider = model => {
  return new _console_parsed_requests_provider.ConsoleParsedRequestsProvider(workerProxyService, model);
};
exports.getParsedRequestsProvider = getParsedRequestsProvider;