"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupModuleBodySchema = exports.recognizeModulesSchemaResponse = exports.recognizeModulesSchema = exports.optionalSizeQuerySchema = exports.optionalModuleIdParamSchema = exports.moduleIdParamSchema = exports.moduleFilterSchema = exports.jobExistsResponse = exports.getModulesSchemaResponse = exports.dataRecognizerConfigResponse = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setupModuleBodySchema = exports.setupModuleBodySchema = _configSchema.schema.object({
  prefix: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Job ID prefix. This will be added to the start of the ID every job created by the module (optional).'
    }
  })),
  groups: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    meta: {
      description: 'List of group IDs. This will override the groups assigned to each job created by the module (optional).'
    }
  })),
  indexPatternName: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: `Name of kibana index pattern. Overrides the index used in each datafeed and each index pattern used in the custom urls and saved objects created by the module. A matching index pattern must exist in kibana if the module contains custom urls or saved objects which rely on an index pattern ID. If the module does not contain custom urls or saved objects which require an index pattern ID, the indexPatternName can be any index name or pattern that will match an ES index. It can also be a comma separated list of names. If no indexPatternName is supplied, the default index pattern specified in the manifest.json will be used (optional).`
    }
  })),
  query: _configSchema.schema.maybe(_configSchema.schema.any({
    meta: {
      description: 'ES Query DSL object. Overrides the query object for each datafeed created by the module (optional).'
    }
  })),
  useDedicatedIndex: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Flag to specify that each job created by the module uses a dedicated index (optional).'
    }
  })),
  startDatafeed: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Flag to specify that each datafeed created by the module is started once saved. Defaults to <code>false</code> (optional).'
    }
  })),
  start: _configSchema.schema.maybe(_configSchema.schema.number({
    meta: {
      description: 'Start date for datafeed. Specified in epoch seconds. Only used if startDatafeed is true. If not specified, a value of 0 is used i.e. start at the beginning of the data (optional).'
    }
  })),
  end: _configSchema.schema.maybe(_configSchema.schema.number({
    meta: {
      description: `End date for datafeed. Specified in epoch seconds. Only used if startDatafeed is true. If not specified, the datafeed will continue to run in real time (optional).`
    }
  })),
  jobOverrides: _configSchema.schema.maybe(_configSchema.schema.any({
    meta: {
      description: 'Partial job configuration which will override jobs contained in the module. Can be an array of objects. If a <code>job_id</code> is specified, only that job in the module will be overridden. Applied before any of the existing overridable options (e.g. useDedicatedIndex, groups, indexPatternName etc) and so can be overridden themselves (optional).'
    }
  })),
  datafeedOverrides: _configSchema.schema.maybe(_configSchema.schema.any({
    meta: {
      description: 'Partial datafeed configuration which will override datafeeds contained in the module. Can be an array of objects. If a datafeed_id or a job_id is specified, only that datafeed in the module will be overridden. Applied before any of the existing overridable options (e.g. useDedicatedIndex, groups, indexPatternName etc) and so can be overridden themselves (optional).'
    }
  })),
  estimateModelMemory: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether an estimate of the model memory limit should be made by checking the cardinality of fields in the job configurations (optional).'
    }
  })),
  applyToAllSpaces: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Add each job created to the * space (optional)'
    }
  }))
});
const optionalModuleIdParamSchema = exports.optionalModuleIdParamSchema = _configSchema.schema.object({
  moduleId: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'ID of the module'
    }
  }))
});
const moduleIdParamSchema = exports.moduleIdParamSchema = _configSchema.schema.object({
  moduleId: _configSchema.schema.string({
    meta: {
      description: 'ID of the module'
    }
  })
});
const optionalSizeQuerySchema = exports.optionalSizeQuerySchema = _configSchema.schema.object({
  size: _configSchema.schema.maybe(_configSchema.schema.number({
    meta: {
      description: 'How many results to return'
    }
  }))
});
const recognizeModulesSchema = exports.recognizeModulesSchema = _configSchema.schema.object({
  indexPatternTitle: _configSchema.schema.string({
    meta: {
      description: 'Index pattern to recognize. Note that this does not need to be a Kibana index pattern, and can be the name of a single Elasticsearch index, or include a wildcard (*) to match multiple indices.'
    }
  })
});
const moduleFilterSchema = exports.moduleFilterSchema = _configSchema.schema.object({
  filter: _configSchema.schema.maybe(_configSchema.schema.string())
});
const recognizeModulesSchemaResponse = () => _configSchema.schema.arrayOf(_configSchema.schema.object({
  id: _configSchema.schema.string(),
  title: _configSchema.schema.string(),
  query: _configSchema.schema.any(),
  description: _configSchema.schema.string(),
  logo: _configSchema.schema.any()
}));
exports.recognizeModulesSchemaResponse = recognizeModulesSchemaResponse;
const moduleSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  title: _configSchema.schema.string(),
  description: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  logo: _configSchema.schema.maybe(_configSchema.schema.any()),
  logoFile: _configSchema.schema.maybe(_configSchema.schema.string()),
  defaultIndexPattern: _configSchema.schema.maybe(_configSchema.schema.string()),
  query: _configSchema.schema.maybe(_configSchema.schema.any()),
  jobs: _configSchema.schema.arrayOf(_configSchema.schema.any()),
  datafeeds: _configSchema.schema.arrayOf(_configSchema.schema.any()),
  kibana: _configSchema.schema.maybe(_configSchema.schema.any()),
  tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});
const getModulesSchemaResponse = () => _configSchema.schema.oneOf([moduleSchema, _configSchema.schema.arrayOf(moduleSchema)]);

/**
 *
 * @link DataRecognizerConfigResponse
 */
exports.getModulesSchemaResponse = getModulesSchemaResponse;
const dataRecognizerConfigResponse = () => _configSchema.schema.object({
  datafeeds: _configSchema.schema.arrayOf(_configSchema.schema.any()),
  jobs: _configSchema.schema.arrayOf(_configSchema.schema.any()),
  kibana: _configSchema.schema.maybe(_configSchema.schema.any())
});
exports.dataRecognizerConfigResponse = dataRecognizerConfigResponse;
const jobExistsResponse = () => _configSchema.schema.object({
  jobsExist: _configSchema.schema.boolean(),
  jobs: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    earliestTimestampMs: _configSchema.schema.number(),
    latestTimestampMs: _configSchema.schema.number(),
    latestResultsTimestampMs: _configSchema.schema.maybe(_configSchema.schema.number())
  })))
});
exports.jobExistsResponse = jobExistsResponse;