"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDeepLinks = getDeepLinks;
var _i18n = require("@kbn/i18n");
var _locator = require("../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createDeepLinks(mlCapabilities, isFullLicense, isServerless, esqlEnabled) {
  return {
    getOverviewLinkDeepLink: () => {
      if (!isFullLicense) return null;
      return {
        id: 'overview',
        title: _i18n.i18n.translate('xpack.ml.deepLink.overview', {
          defaultMessage: 'Overview'
        }),
        path: `/${_locator.ML_PAGES.OVERVIEW}`
      };
    },
    getAnomalyDetectionDeepLink: () => {
      if (!isFullLicense || !mlCapabilities.isADEnabled) return null;
      return {
        id: 'anomalyDetection',
        title: _i18n.i18n.translate('xpack.ml.deepLink.anomalyDetection', {
          defaultMessage: 'Anomaly detection'
        }),
        deepLinks: [{
          id: 'anomalyExplorer',
          title: _i18n.i18n.translate('xpack.ml.deepLink.anomalyExplorer', {
            defaultMessage: 'Anomaly explorer'
          }),
          path: `/${_locator.ML_PAGES.ANOMALY_EXPLORER}`
        }, {
          id: 'singleMetricViewer',
          title: _i18n.i18n.translate('xpack.ml.deepLink.singleMetricViewer', {
            defaultMessage: 'Single metric viewer'
          }),
          path: `/${_locator.ML_PAGES.SINGLE_METRIC_VIEWER}`
        }, {
          id: 'suppliedConfigurations',
          title: _i18n.i18n.translate('xpack.ml.deepLink.suppliedConfigurations', {
            defaultMessage: 'Supplied configurations'
          }),
          // @deprecated since 9.1, kept here to redirect to new management page location
          // TODO: Change redirect to management page once #213152 is resolved
          path: `/supplied_configurations`
        }]
      };
    },
    getDataFrameAnalyticsDeepLink: () => {
      if (!isFullLicense || !mlCapabilities.isDFAEnabled) return null;
      return {
        id: 'dataFrameAnalytics',
        title: _i18n.i18n.translate('xpack.ml.deepLink.dataFrameAnalytics', {
          defaultMessage: 'Data Frame Analytics'
        }),
        deepLinks: [{
          id: 'resultExplorer',
          title: _i18n.i18n.translate('xpack.ml.deepLink.resultExplorer', {
            defaultMessage: 'Results explorer'
          }),
          path: `/${_locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION}`
        }, {
          id: 'analyticsMap',
          title: _i18n.i18n.translate('xpack.ml.deepLink.analyticsMap', {
            defaultMessage: 'Analytics map'
          }),
          path: `/${_locator.ML_PAGES.DATA_FRAME_ANALYTICS_MAP}`
        }]
      };
    },
    getModelManagementDeepLink: () => {
      if (!mlCapabilities.isDFAEnabled && !mlCapabilities.isNLPEnabled) return null;
      if (!isServerless) {
        return {
          id: 'nodes',
          title: _i18n.i18n.translate('xpack.ml.deepLink.nodes', {
            defaultMessage: 'Nodes'
          }),
          // TODO: Change redirect to management page once #213152 is resolved
          path: `/${_locator.ML_PAGES.NODES}`
        };
      }
      return null;
    },
    getMemoryUsageDeepLink: () => {
      if (!isFullLicense) return null;
      return {
        id: 'memoryUsage',
        title: _i18n.i18n.translate('xpack.ml.deepLink.memoryUsage', {
          defaultMessage: 'Memory Usage'
        }),
        // TODO: Change redirect to management page once #213152 is resolved
        path: `/${_locator.ML_PAGES.MEMORY_USAGE}`
      };
    },
    getAiopsDeepLink: () => {
      if (!mlCapabilities.canUseAiops) return null;
      return {
        id: 'aiOps',
        title: _i18n.i18n.translate('xpack.ml.deepLink.aiOps', {
          defaultMessage: 'AIOps'
        }),
        // Default to the index select page for log rate analysis since we don't have an AIops overview page
        path: `/${_locator.ML_PAGES.AIOPS_LOG_RATE_ANALYSIS_INDEX_SELECT}`,
        deepLinks: [{
          id: 'logRateAnalysis',
          title: _i18n.i18n.translate('xpack.ml.deepLink.logRateAnalysis', {
            defaultMessage: 'Log rate analysis'
          }),
          path: `/${_locator.ML_PAGES.AIOPS_LOG_RATE_ANALYSIS_INDEX_SELECT}`
        }, {
          id: 'logRateAnalysisPage',
          title: _i18n.i18n.translate('xpack.ml.deepLink.logRateAnalysis', {
            defaultMessage: 'Log rate analysis'
          }),
          path: `/${_locator.ML_PAGES.AIOPS_LOG_RATE_ANALYSIS}`,
          visibleIn: []
        }, {
          id: 'logPatternAnalysis',
          title: _i18n.i18n.translate('xpack.ml.deepLink.logPatternAnalysis', {
            defaultMessage: 'Log pattern analysis'
          }),
          path: `/${_locator.ML_PAGES.AIOPS_LOG_CATEGORIZATION_INDEX_SELECT}`
        }, {
          id: 'logPatternAnalysisPage',
          title: _i18n.i18n.translate('xpack.ml.deepLink.logPatternAnalysis', {
            defaultMessage: 'Log pattern analysis'
          }),
          path: `/${_locator.ML_PAGES.AIOPS_LOG_CATEGORIZATION}`,
          visibleIn: []
        }, {
          id: 'changePointDetections',
          title: _i18n.i18n.translate('xpack.ml.deepLink.changePointDetection', {
            defaultMessage: 'Change point detection'
          }),
          path: `/${_locator.ML_PAGES.AIOPS_CHANGE_POINT_DETECTION_INDEX_SELECT}`
        }, {
          id: 'changePointDetectionsPage',
          title: _i18n.i18n.translate('xpack.ml.deepLink.changePointDetection', {
            defaultMessage: 'Change point detection'
          }),
          path: `/${_locator.ML_PAGES.AIOPS_CHANGE_POINT_DETECTION}`,
          visibleIn: []
        }]
      };
    },
    getNotificationsDeepLink: () => {
      if (!isFullLicense) return null;
      return {
        id: 'notifications',
        title: _i18n.i18n.translate('xpack.ml.deepLink.notifications', {
          defaultMessage: 'Notifications'
        }),
        // TODO: Change redirect to management page once #213152 is resolved
        path: `/${_locator.ML_PAGES.NOTIFICATIONS}`
      };
    },
    getDataVisualizerDeepLink: () => {
      return {
        id: 'dataVisualizer',
        title: _i18n.i18n.translate('xpack.ml.deepLink.dataVisualizer', {
          defaultMessage: 'Data visualizer'
        }),
        path: `/${_locator.ML_PAGES.DATA_VISUALIZER}`
      };
    },
    getFileUploadDeepLink: () => {
      return {
        id: 'fileUpload',
        title: _i18n.i18n.translate('xpack.ml.deepLink.fileUpload', {
          defaultMessage: 'File upload'
        }),
        keywords: ['CSV', 'JSON'],
        path: `/${_locator.ML_PAGES.DATA_VISUALIZER_FILE}`
      };
    },
    getIndexDataVisualizerDeepLink: () => {
      return {
        id: 'indexDataVisualizer',
        title: _i18n.i18n.translate('xpack.ml.deepLink.indexDataVisualizer', {
          defaultMessage: 'Index data visualizer'
        }),
        path: `/${_locator.ML_PAGES.DATA_VISUALIZER_INDEX_SELECT}`
      };
    },
    getIndexDataVisualizerPageDeepLink: () => {
      return {
        id: 'indexDataVisualizerPage',
        title: _i18n.i18n.translate('xpack.ml.deepLink.indexDataVisualizer', {
          defaultMessage: 'Index data visualizer'
        }),
        path: `/${_locator.ML_PAGES.DATA_VISUALIZER_INDEX_VIEWER}`,
        visibleIn: []
      };
    },
    getESQLDataVisualizerDeepLink: () => {
      if (!esqlEnabled) return null;
      return {
        id: 'esqlDataVisualizer',
        title: _i18n.i18n.translate('xpack.ml.deepLink.esqlDataVisualizer', {
          defaultMessage: 'ES|QL data visualizer'
        }),
        path: `/${_locator.ML_PAGES.DATA_VISUALIZER_ESQL}`
      };
    },
    getDataDriftDeepLink: () => {
      return {
        id: 'dataDrift',
        title: _i18n.i18n.translate('xpack.ml.deepLink.dataDrift', {
          defaultMessage: 'Data drift'
        }),
        path: `/${_locator.ML_PAGES.DATA_DRIFT_INDEX_SELECT}`
      };
    },
    getDataDriftPageDeepLink: () => {
      return {
        id: 'dataDriftPage',
        title: _i18n.i18n.translate('xpack.ml.deepLink.dataDrift', {
          defaultMessage: 'Data drift'
        }),
        path: `/${_locator.ML_PAGES.DATA_DRIFT}`,
        visibleIn: []
      };
    }
  };
}
function getDeepLinks(isFullLicense, mlCapabilities, isServerless, esqlEnabled) {
  const links = createDeepLinks(mlCapabilities, isFullLicense, isServerless, esqlEnabled);
  return Object.values(links).map(link => link()).filter(link => link !== null);
}