"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableAnomalyChartsUserInput = EmbeddableAnomalyChartsUserInput;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _http_service = require("../../application/services/http_service");
var _anomaly_charts_initializer = require("./anomaly_charts_initializer");
var _jobs = require("../../application/services/ml_api_service/jobs");
var _get_services = require("../../application/util/get_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/embeddables/anomaly_charts/anomaly_charts_setup_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EmbeddableAnomalyChartsUserInput({
  coreStart,
  pluginStart,
  onConfirm,
  onCancel,
  input
}) {
  const {
    http
  } = coreStart;
  const adJobsApiService = (0, _jobs.jobsApiProvider)(new _http_service.HttpService(http));
  const mlServices = (0, _get_services.getMlGlobalServices)(coreStart, pluginStart.data.dataViews);
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...coreStart,
      ...pluginStart,
      mlServices
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_anomaly_charts_initializer.AnomalyChartsInitializer, {
    initialInput: input,
    onCreate: onConfirm,
    onCancel: onCancel,
    adJobsApiService: adJobsApiService,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }));
}