"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeBucketsFromCache = getTimeBucketsFromCache;
var _public = require("@kbn/data-plugin/public");
var _mlTimeBuckets = require("@kbn/ml-time-buckets");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTimeBucketsFromCache(uiSettings) {
  return new _mlTimeBuckets.TimeBuckets({
    [_public.UI_SETTINGS.HISTOGRAM_MAX_BARS]: uiSettings.get(_public.UI_SETTINGS.HISTOGRAM_MAX_BARS),
    [_public.UI_SETTINGS.HISTOGRAM_BAR_TARGET]: uiSettings.get(_public.UI_SETTINGS.HISTOGRAM_BAR_TARGET),
    dateFormat: uiSettings.get('dateFormat'),
    'dateFormat:scaled': uiSettings.get('dateFormat:scaled')
  });
}