"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ForecastingModal = exports.FORECAST_DURATION_MAX_DAYS = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _mlParseInterval = require("@kbn/ml-parse-interval");
var _states = require("../../../../../common/constants/states");
var _message_levels = require("../../../../../common/constants/message_levels");
var _job_utils = require("../../../../../common/util/job_utils");
var _modal = require("./modal");
var _progress_states = require("./progress_states");
var _forecast_service = require("../../../services/forecast_service");
var _forecast_button = require("./forecast_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/timeseriesexplorer/components/forecasting_modal/forecasting_modal.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React modal dialog which allows the user to run and view time series forecasts.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FORECAST_DURATION_MAX_DAYS = exports.FORECAST_DURATION_MAX_DAYS = 3650; // Max forecast duration allowed by analytics.
const STATUS_FINISHED_QUERY = {
  term: {
    forecast_status: _states.FORECAST_REQUEST_STATE.FINISHED
  }
};
const FORECASTS_VIEW_MAX = 5; // Display links to a maximum of 5 forecasts.
const FORECAST_JOB_MIN_VERSION = '6.1.0'; // Forecasting only allowed for jobs created >= 6.1.0.
const FORECAST_DURATION_MAX_MS = FORECAST_DURATION_MAX_DAYS * 86400000;
const WARN_NUM_PARTITIONS = 100; // Warn about running a forecast with this number of field values.
const FORECAST_STATS_POLL_FREQUENCY = 250; // Frequency in ms at which to poll for forecast request stats.
const WARN_NO_PROGRESS_MS = 120000; // If no progress in forecast request, abort check and warn.

function getDefaultState() {
  return {
    isModalVisible: false,
    previousForecasts: [],
    isForecastRequested: false,
    forecastProgress: _progress_states.PROGRESS_STATES.UNSET,
    jobOpeningState: _progress_states.PROGRESS_STATES.UNSET,
    jobClosingState: _progress_states.PROGRESS_STATES.UNSET,
    newForecastDuration: '1d',
    isNewForecastDurationValid: true,
    newForecastDurationErrors: [],
    neverExpires: false,
    messages: []
  };
}
class ForecastingModal extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "addMessage", (message, status, clearFirst = false) => {
      const msg = {
        message,
        status
      };
      this.setState(prevState => ({
        messages: clearFirst ? [msg] : [...prevState.messages, msg]
      }));
    });
    (0, _defineProperty2.default)(this, "viewForecast", forecastId => {
      this.props.setForecastId(forecastId);
      if (this.props.onForecastComplete !== undefined && this.state.previousForecasts.length > 0) {
        const forecastToView = this.state.previousForecasts.find(forecast => forecastId === forecast.forecast_id);
        this.props.onForecastComplete(forecastToView.forecast_end_timestamp);
      }
      this.closeModal();
    });
    (0, _defineProperty2.default)(this, "onNeverExpiresChange", event => {
      this.setState({
        neverExpires: event.target.checked
      });
    });
    (0, _defineProperty2.default)(this, "onNewForecastDurationChange", event => {
      const newForecastDurationErrors = [];
      let isNewForecastDurationValid = true;
      const duration = (0, _mlParseInterval.parseInterval)(event.target.value);
      if (duration === null) {
        isNewForecastDurationValid = false;
        newForecastDurationErrors.push(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastingModal.invalidDurationFormatErrorMessage', {
          defaultMessage: 'Invalid duration format'
        }));
      } else if (duration.asMilliseconds() > FORECAST_DURATION_MAX_MS) {
        isNewForecastDurationValid = false;
        newForecastDurationErrors.push(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastingModal.forecastDurationMustNotBeGreaterThanMaximumErrorMessage', {
          defaultMessage: 'Forecast duration must not be greater than {maximumForecastDurationDays} days',
          values: {
            maximumForecastDurationDays: FORECAST_DURATION_MAX_DAYS
          }
        }));
      } else if (duration.asMilliseconds() === 0) {
        isNewForecastDurationValid = false;
        newForecastDurationErrors.push(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastingModal.forecastDurationMustNotBeZeroErrorMessage', {
          defaultMessage: 'Forecast duration must not be zero'
        }));
      }
      this.setState({
        newForecastDuration: event.target.value,
        isNewForecastDurationValid,
        newForecastDurationErrors
      });
    });
    (0, _defineProperty2.default)(this, "checkJobStateAndRunForecast", () => {
      this.setState({
        isForecastRequested: true,
        messages: []
      });

      // A forecast can only be run on an opened job,
      // so open job if it is closed.
      if (this.props.jobState === _states.JOB_STATE.CLOSED || this.props.job.state === _states.JOB_STATE.CLOSED) {
        this.openJobAndRunForecast();
      } else {
        this.runForecast(false);
      }
    });
    (0, _defineProperty2.default)(this, "openJobAndRunForecast", () => {
      // Opens a job in a 'closed' state prior to running a forecast.
      this.setState({
        jobOpeningState: _progress_states.PROGRESS_STATES.WAITING
      });
      this.context.services.mlServices.mlApi.openJob({
        jobId: this.props.job.job_id
      }).then(() => {
        // If open was successful run the forecast, then close the job again.
        this.setState({
          jobOpeningState: _progress_states.PROGRESS_STATES.DONE
        });
        this.runForecast(true);
      }).catch(resp => {
        console.log('Time series forecast modal - could not open job:', resp);
        this.addMessage(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastingModal.errorWithOpeningJobBeforeRunningForecastErrorMessage', {
          defaultMessage: 'Error opening job before running forecast'
        }), _message_levels.MESSAGE_LEVEL.ERROR);
        this.setState({
          jobOpeningState: _progress_states.PROGRESS_STATES.ERROR
        });
      });
    });
    (0, _defineProperty2.default)(this, "runForecastErrorHandler", (resp, closeJob) => {
      this.setState({
        forecastProgress: _progress_states.PROGRESS_STATES.ERROR
      });
      console.log('Time series forecast modal - error running forecast:', resp);
      const errorMessage = resp ? (0, _mlErrorUtils.extractErrorMessage)(resp) : undefined;
      if (errorMessage && errorMessage.length > 0) {
        this.addMessage(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastingModal.errorRunningForecastMessage', {
          defaultMessage: 'An error has occurred running the forecast: {errorMessage}',
          values: {
            errorMessage
          }
        }), _message_levels.MESSAGE_LEVEL.ERROR, true);
      } else {
        this.addMessage(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastingModal.unexpectedResponseFromRunningForecastErrorMessage', {
          defaultMessage: 'Unexpected response from running forecast. The request may have failed.'
        }), _message_levels.MESSAGE_LEVEL.ERROR, true);
      }
      if (closeJob === true) {
        this.setState({
          jobClosingState: _progress_states.PROGRESS_STATES.WAITING
        });
        this.context.services.mlServices.mlApi.closeJob({
          jobId: this.props.job.job_id
        }).then(() => {
          this.setState({
            jobClosingState: _progress_states.PROGRESS_STATES.DONE
          });
        }).catch(response => {
          console.log('Time series forecast modal - could not close job:', response);
          this.addMessage(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastingModal.errorWithClosingJobErrorMessage', {
            defaultMessage: 'Error closing job'
          }), _message_levels.MESSAGE_LEVEL.ERROR);
          this.setState({
            jobClosingState: _progress_states.PROGRESS_STATES.ERROR
          });
        });
      }
    });
    (0, _defineProperty2.default)(this, "runForecast", closeJobAfterRunning => {
      this.setState({
        forecastProgress: 0
      });

      // Always supply the duration to the endpoint in seconds as some of the moment duration
      // formats accepted by Kibana (w, M, y) are not valid formats in Elasticsearch.
      const durationInSeconds = (0, _mlParseInterval.parseInterval)(this.state.newForecastDuration).asSeconds();
      this.mlForecastService.runForecast(this.props.job.job_id, `${durationInSeconds}s`, this.state.neverExpires).then(resp => {
        // Endpoint will return { acknowledged:true, id: <now timestamp> } before forecast is complete.
        // So wait for results and then refresh the dashboard to the end of the forecast.
        if (resp.forecast_id !== undefined) {
          this.waitForForecastResults(resp.forecast_id, closeJobAfterRunning);
        } else {
          this.runForecastErrorHandler(resp, closeJobAfterRunning);
        }
      }).catch(resp => this.runForecastErrorHandler(resp, closeJobAfterRunning));
    });
    (0, _defineProperty2.default)(this, "waitForForecastResults", (forecastId, closeJobAfterRunning) => {
      // Obtain the stats for the forecast request and check forecast is progressing.
      // When the stats show the forecast is finished, load the
      // forecast results into the view.
      let previousProgress = 0;
      let noProgressMs = 0;
      this.forecastChecker = setInterval(() => {
        this.mlForecastService.getForecastRequestStats(this.props.job, forecastId).then(resp => {
          // Get the progress (stats value is between 0 and 1).
          const progress = (0, _lodash.get)(resp, ['stats', 'forecast_progress'], previousProgress);
          const status = (0, _lodash.get)(resp, ['stats', 'forecast_status']);

          // The requests for forecast stats can get routed to different shards,
          // and if these operate at different speeds there is a chance that a
          // previous request could arrive later.
          // The progress reported by the back-end should never go down, so
          // to be on the safe side, only update state if progress has increased.
          if (progress > previousProgress) {
            this.setState({
              forecastProgress: Math.round(100 * progress)
            });
          }

          // Display any messages returned in the request stats.
          let messages = (0, _lodash.get)(resp, ['stats', 'forecast_messages'], []);
          messages = messages.map(message => ({
            message,
            status: _message_levels.MESSAGE_LEVEL.WARNING
          }));
          this.setState({
            messages
          });
          if (status === _states.FORECAST_REQUEST_STATE.FINISHED) {
            clearInterval(this.forecastChecker);
            if (this.props.onForecastComplete !== undefined) {
              this.props.onForecastComplete(resp.stats.forecast_end_timestamp);
            }
            if (closeJobAfterRunning === true) {
              this.setState({
                jobClosingState: _progress_states.PROGRESS_STATES.WAITING
              });
              this.context.services.mlServices.mlApi.closeJob({
                jobId: this.props.job.job_id
              }).then(() => {
                this.setState({
                  jobClosingState: _progress_states.PROGRESS_STATES.DONE
                });
                this.props.setForecastId(forecastId);
                this.closeAfterRunningForecast();
              }).catch(response => {
                // Load the forecast data in the main page,
                // but leave this dialog open so the error can be viewed.
                console.log('Time series forecast modal - could not close job:', response);
                this.addMessage(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastingModal.errorWithClosingJobAfterRunningForecastErrorMessage', {
                  defaultMessage: 'Error closing job after running forecast'
                }), _message_levels.MESSAGE_LEVEL.ERROR);
                this.setState({
                  jobClosingState: _progress_states.PROGRESS_STATES.ERROR
                });
                this.props.setForecastId(forecastId);
              });
            } else {
              this.props.setForecastId(forecastId);
              this.closeAfterRunningForecast();
            }
          } else {
            // Display a warning and abort check if the forecast hasn't
            // progressed for WARN_NO_PROGRESS_MS.
            if (progress === previousProgress) {
              noProgressMs += FORECAST_STATS_POLL_FREQUENCY;
              if (noProgressMs > WARN_NO_PROGRESS_MS) {
                console.log(`Forecast request has not progressed for ${WARN_NO_PROGRESS_MS}ms. Cancelling check.`);
                this.addMessage(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastingModal.noProgressReportedForNewForecastErrorMessage', {
                  defaultMessage: 'No progress reported for the new forecast for {WarnNoProgressMs}ms.' + 'An error may have occurred whilst running the forecast.',
                  values: {
                    WarnNoProgressMs: WARN_NO_PROGRESS_MS
                  }
                }), _message_levels.MESSAGE_LEVEL.ERROR);

                // Try and load any results which may have been created.
                this.props.setForecastId(forecastId);
                this.setState({
                  forecastProgress: _progress_states.PROGRESS_STATES.ERROR
                });
                clearInterval(this.forecastChecker);
              }
            } else {
              if (progress > previousProgress) {
                previousProgress = progress;
              }

              // Reset the 'no progress' check value.
              noProgressMs = 0;
            }
          }
        }).catch(resp => {
          console.log('Time series forecast modal - error loading stats of forecast from elasticsearch:', resp);
          this.addMessage(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastingModal.errorWithLoadingStatsOfRunningForecastErrorMessage', {
            defaultMessage: 'Error loading stats of running forecast.'
          }), _message_levels.MESSAGE_LEVEL.ERROR);
          this.setState({
            forecastProgress: _progress_states.PROGRESS_STATES.ERROR
          });
          clearInterval(this.forecastChecker);
        });
      }, FORECAST_STATS_POLL_FREQUENCY);
    });
    (0, _defineProperty2.default)(this, "openModal", () => {
      const {
        job,
        entities,
        earliestRecordTimestamp,
        latestRecordTimestamp
      } = this.props;
      if (typeof job === 'object') {
        // Get the list of all the finished forecasts for this job with results at or later than the dashboard 'from' time.
        const {
          timefilter
        } = this.context.services.data.query.timefilter;
        const bounds = timefilter.getActiveBounds();
        this.mlForecastService.getForecastsSummary(job, STATUS_FINISHED_QUERY, bounds.min.valueOf(), FORECASTS_VIEW_MAX).then(resp => {
          this.setState({
            previousForecasts: resp.forecasts
          });
        }).catch(resp => {
          console.log('Time series forecast modal - error obtaining forecasts summary:', resp);
          this.addMessage(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastingModal.errorWithObtainingListOfPreviousForecastsErrorMessage', {
            defaultMessage: 'Error obtaining list of previous forecasts'
          }), _message_levels.MESSAGE_LEVEL.ERROR);
        });

        // Display a warning about running a forecast if there is high number
        // of partitioning fields.
        const entityFieldNames = entities.map(entity => entity.fieldName);
        if (entityFieldNames.length > 0) {
          this.context.services.mlServices.mlApi.getCardinalityOfFields({
            index: job.datafeed_config.indices,
            fieldNames: entityFieldNames,
            query: job.datafeed_config.query,
            timeFieldName: job.data_description.time_field,
            earliestMs: earliestRecordTimestamp,
            latestMs: latestRecordTimestamp
          }).then(results => {
            let numPartitions = 1;
            Object.values(results).forEach(cardinality => {
              numPartitions = numPartitions * cardinality;
            });
            if (numPartitions > WARN_NUM_PARTITIONS) {
              this.addMessage(_i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastingModal.dataContainsMorePartitionsMessage', {
                defaultMessage: 'Note that this data contains more than {warnNumPartitions} ' + 'partitions so running a forecast may take a long time and consume a high amount of resource',
                values: {
                  warnNumPartitions: WARN_NUM_PARTITIONS
                }
              }), _message_levels.MESSAGE_LEVEL.WARNING);
            }
          }).catch(resp => {
            console.log('Time series forecast modal - error obtaining cardinality of fields:', resp);
          });
        }
        this.setState({
          isModalVisible: true
        });
      }
    });
    (0, _defineProperty2.default)(this, "closeAfterRunningForecast", () => {
      // Only close the dialog automatically after a forecast has run
      // if the message bar is clear. Otherwise the user may not catch
      // any messages returned in the forecast request stats.
      if (this.state.messages.length === 0) {
        // Wrap the close in a timeout to give the user a chance to see progress update.
        setTimeout(() => {
          this.closeModal();
        }, 1000);
      }
    });
    (0, _defineProperty2.default)(this, "closeModal", () => {
      if (this.forecastChecker !== null) {
        clearInterval(this.forecastChecker);
      }
      this.setState(getDefaultState());
    });
    this.state = getDefaultState();

    // Used to poll for updates on a running forecast.
    this.forecastChecker = null;
    this.mlForecastService;
  }

  /**
   * Access ML services in react context.
   */

  componentDidMount() {
    this.mlForecastService = (0, _forecast_service.forecastServiceFactory)(this.context.services.mlServices.mlApi);
  }
  render() {
    // Forecasting disabled if detector has an over field or job created < 6.1.0.
    let isForecastingDisabled = false;
    let forecastingDisabledMessage = null;
    const {
      job
    } = this.props;
    if (job !== undefined) {
      const detector = job.analysis_config.detectors[this.props.detectorIndex];
      const overFieldName = detector.over_field_name;
      if (overFieldName !== undefined) {
        isForecastingDisabled = true;
        forecastingDisabledMessage = _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastingModal.forecastingNotAvailableForPopulationDetectorsMessage', {
          defaultMessage: 'Forecasting is not available for population detectors with an over field'
        });
      } else if ((0, _job_utils.isJobVersionGte)(job, FORECAST_JOB_MIN_VERSION) === false) {
        isForecastingDisabled = true;
        forecastingDisabledMessage = _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.forecastingModal.forecastingOnlyAvailableForJobsCreatedInSpecifiedVersionMessage', {
          defaultMessage: 'Forecasting is only available for jobs created in version {minVersion} or later',
          values: {
            minVersion: FORECAST_JOB_MIN_VERSION
          }
        });
      }
    }
    const forecastButton = /*#__PURE__*/_react.default.createElement(_forecast_button.ForecastButton, {
      onClick: this.openModal,
      isDisabled: isForecastingDisabled,
      mode: this.props.buttonMode,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 534,
        columnNumber: 7
      }
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 542,
        columnNumber: 7
      }
    }, isForecastingDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "left",
      content: forecastingDisabledMessage,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 544,
        columnNumber: 11
      }
    }, forecastButton) : forecastButton, this.state.isModalVisible && /*#__PURE__*/_react.default.createElement(_modal.Modal, {
      jobState: this.props.jobState,
      job: this.props.job,
      forecasts: this.state.previousForecasts,
      close: this.closeModal,
      viewForecast: this.viewForecast,
      runForecast: this.checkJobStateAndRunForecast,
      newForecastDuration: this.state.newForecastDuration,
      onNewForecastDurationChange: this.onNewForecastDurationChange,
      onNeverExpiresChange: this.onNeverExpiresChange,
      neverExpires: this.state.neverExpires,
      isNewForecastDurationValid: this.state.isNewForecastDurationValid,
      newForecastDurationErrors: this.state.newForecastDurationErrors,
      isForecastRequested: this.state.isForecastRequested,
      forecastProgress: this.state.forecastProgress,
      jobOpeningState: this.state.jobOpeningState,
      jobClosingState: this.state.jobClosingState,
      messages: this.state.messages,
      selectedForecastId: this.props.selectedForecastId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 552,
        columnNumber: 11
      }
    }));
  }
}
exports.ForecastingModal = ForecastingModal;
(0, _defineProperty2.default)(ForecastingModal, "propTypes", {
  buttonMode: _propTypes.default.string,
  isDisabled: _propTypes.default.bool,
  job: _propTypes.default.object,
  jobState: _propTypes.default.string,
  detectorIndex: _propTypes.default.number,
  earliestRecordTimestamp: _propTypes.default.number,
  latestRecordTimestamp: _propTypes.default.number,
  entities: _propTypes.default.array,
  setForecastId: _propTypes.default.func,
  selectedForecastId: _propTypes.default.string
});
(0, _defineProperty2.default)(ForecastingModal, "contextType", _public.context);