"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notificationsProvider = notificationsProvider;
var _lodash = require("lodash");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _app = require("../../../../common/constants/app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function notificationsProvider(httpService) {
  return {
    findMessages(params) {
      return httpService.http({
        path: `${_app.ML_INTERNAL_BASE_PATH}/notifications`,
        method: 'GET',
        query: (0, _lodash.omitBy)(params, v => !(0, _mlIsDefined.isDefined)(v)),
        version: '1'
      });
    },
    countMessages$(params) {
      return httpService.http$({
        path: `${_app.ML_INTERNAL_BASE_PATH}/notifications/count`,
        method: 'GET',
        query: (0, _lodash.omitBy)(params, v => !(0, _mlIsDefined.isDefined)(v)),
        version: '1'
      });
    }
  };
}