"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertingApiProvider = void 0;
exports.useAlertingApiService = useAlertingApiService;
var _react = require("react");
var _kibana = require("../../contexts/kibana");
var _app = require("../../../../common/constants/app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertingApiProvider = httpService => {
  return {
    preview(params) {
      const body = JSON.stringify(params);
      return httpService.http({
        path: `${_app.ML_INTERNAL_BASE_PATH}/alerting/preview`,
        method: 'POST',
        body,
        version: '1'
      });
    }
  };
};
exports.alertingApiProvider = alertingApiProvider;
/**
 * Hooks for accessing {@link AlertingApiService} in React components.
 */
function useAlertingApiService() {
  const {
    services: {
      mlServices: {
        httpService
      }
    }
  } = (0, _kibana.useMlKibana)();
  return (0, _react.useMemo)(() => alertingApiProvider(httpService), [httpService]);
}