"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overviewPanelDefaultState = exports.default = exports.OverviewPage = exports.MLOverviewCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _esqlUtils = require("@kbn/esql-utils");
var _upgrade = require("../components/upgrade");
var _help_menu = require("../components/help_menu");
var _kibana = require("../contexts/kibana");
var _use_create_url = require("../contexts/kibana/use_create_url");
var _locator = require("../../../common/constants/locator");
var _page_header = require("../components/page_header");
var _anomaly_detection_overview = require("./components/anomaly_detection_overview");
var _data_frame_analytics_overview = require("./components/data_frame_analytics_overview");
var _ml = require("../contexts/ml");
var _data_visualizer_grid = require("./data_visualizer_grid");
var _overview_ml_footer_item = require("./components/overview_ml_footer_item");
var _check_capabilities = require("../capabilities/check_capabilities");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/overview/overview_ml_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const overviewPanelDefaultState = exports.overviewPanelDefaultState = Object.freeze({
  nodes: true,
  adJobs: true,
  dfaJobs: true
});
const MLOverviewCard = ({
  layout,
  path,
  title,
  description,
  iconType,
  buttonLabel,
  cardDataTestSubj,
  buttonDataTestSubj,
  buttonType = 'empty'
}) => {
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const ButtonComponent = buttonType === 'empty' ? _eui.EuiButtonEmpty : _eui.EuiButton;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": cardDataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    layout: layout,
    "data-test-subj": cardDataTestSubj,
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      size: "s",
      iconType: iconType,
      onClick: () => navigateToPath(path),
      "aria-labelledby": "mlOverviewCardTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 11
      }
    }),
    title: title,
    titleSize: "s",
    titleElement: "h3",
    id: "mlOverviewCardTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(ButtonComponent, {
    flush: "left",
    target: "_self",
    onClick: () => navigateToPath(path),
    "data-test-subj": buttonDataTestSubj,
    "aria-label": buttonLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, buttonLabel)));
};
exports.MLOverviewCard = MLOverviewCard;
const OverviewPage = () => {
  const {
    services: {
      docLinks,
      uiSettings
    }
  } = (0, _kibana.useMlKibana)();
  const {
    isADEnabled,
    isDFAEnabled,
    isNLPEnabled
  } = (0, _ml.useEnabledFeatures)();
  const [canUseAiops] = (0, _check_capabilities.usePermissionCheck)(['canUseAiops']);
  const helpLink = docLinks.links.ml.guide;
  const trainedModelsDocLink = docLinks.links.ml.trainedModels;
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const navigateToTrainedModels = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)('', _locator.ML_PAGES.TRAINED_MODELS_MANAGE);
  const navigateToStackManagementMLOverview = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)('', 'overview');
  const isEsqlEnabled = (0, _react.useMemo)(() => uiSettings.get(_esqlUtils.ENABLE_ESQL), [uiSettings]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, {
    restrictWidth: 1200,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.overview.welcomeBanner.header.title",
    defaultMessage: "Machine Learning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.ml.overview.welcomeBanner.header.titleDescription', {
    defaultMessage: 'Analyze your data and generate models for its patterns of behavior.'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: 1200,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_upgrade.UpgradeWarning, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }, isADEnabled || isDFAEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.ml.overview.analyzeYourDataTitle', {
    defaultMessage: 'Analyze your data'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 19
    }
  }, isADEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlOverviewAnomalyDetectionCard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_anomaly_detection_overview.AnomalyDetectionOverviewCard, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 25
    }
  })) : null, isDFAEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlOverviewCardDataFrameAnalytics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_data_frame_analytics_overview.DataFrameAnalyticsOverviewCard, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 25
    }
  })) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 15
    }
  })) : null, canUseAiops ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.ml.overview.aiopsLabsTitle', {
    defaultMessage: 'AIOps Labs'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "m",
    columns: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    textAlign: "left",
    layout: "vertical",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      size: "s",
      onClick: () => navigateToPath('/aiops/log_rate_analysis_index_select'),
      iconType: "logRateAnalysis",
      "aria-label": _i18n.i18n.translate('xpack.ml.overview.logRateAnalysis.title', {
        defaultMessage: 'Log Rate Analysis'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 25
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logRateAnalysis.title",
      defaultMessage: "Log Rate Analysis",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 25
      }
    }),
    titleElement: "h3",
    titleSize: "s",
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logRateAnalysis.description",
      defaultMessage: "Advanced statistical methods to identify reasons for increases or decreases in log rates and displays the statistically significant data in a tabular format.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 27
      }
    })),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      target: "_self",
      onClick: () => navigateToPath('/aiops/log_rate_analysis_index_select'),
      "data-test-subj": "mlOverviewCardLogRateAnalysisButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logRateAnalysis.startAnalysisButton",
      defaultMessage: "Start analysis",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 27
      }
    })),
    "data-test-subj": "mlOverviewCardLogRateAnalysis",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    textAlign: "left",
    layout: "vertical",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      size: "s",
      iconType: "logPatternAnalysis",
      onClick: () => navigateToPath('/aiops/log_categorization_index_select'),
      "aria-label": _i18n.i18n.translate('xpack.ml.overview.logPatternAnalysisTitle', {
        defaultMessage: 'Log Pattern Analysis'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 25
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logPatternAnalysisTitle",
      defaultMessage: "Log Pattern Analysis",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 25
      }
    }),
    titleElement: "h3",
    titleSize: "s",
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logPatternAnalysisDescription",
      defaultMessage: "Find patterns in unstructured log messages and make it easier to examine your data.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 27
      }
    })),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      target: "_self",
      onClick: () => navigateToPath('/aiops/log_categorization_index_select'),
      "data-test-subj": "mlOverviewCardLogPatternAnalysisButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logPatternAnalysis.startAnalysisButton",
      defaultMessage: "Start analysis",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 284,
        columnNumber: 27
      }
    })),
    "data-test-subj": "mlOverviewCardLogPatternAnalysis",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    textAlign: "left",
    layout: "vertical",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      size: "s",
      iconType: "changePointDetection",
      onClick: () => navigateToPath('/aiops/change_point_detection_index_select'),
      "aria-label": _i18n.i18n.translate('xpack.ml.overview.changePointDetection.title', {
        defaultMessage: 'Change Point Detection'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 25
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.changePointDetection.title",
      defaultMessage: "Change Point Detection",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 315,
        columnNumber: 25
      }
    }),
    titleElement: "h3",
    titleSize: "s",
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.changePointDetection.description",
      defaultMessage: "Change point detection uses the change point aggregation to detect distribution changes, trend changes, and other statistically significant change points in a metric of your time series data.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 324,
        columnNumber: 27
      }
    })),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      target: "_self",
      onClick: () => navigateToPath('/aiops/change_point_detection_index_select'),
      "data-test-subj": "mlOverviewCardChangePointDetectionButton",
      "aria-label": _i18n.i18n.translate('xpack.ml.overview.changePointDetection.startDetectionButton', {
        defaultMessage: 'Start detection'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 331,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.changePointDetection.startDetectionButton",
      defaultMessage: "Start detection",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 345,
        columnNumber: 27
      }
    })),
    "data-test-subj": "mlOverviewCardChangePointDetection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 21
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 15
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.ml.overview.visualizeYourDataTitle', {
    defaultMessage: 'Visualize your data'
  }))), /*#__PURE__*/_react.default.createElement(_data_visualizer_grid.DataVisualizerGrid, {
    isEsqlEnabled: isEsqlEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 7
    }
  }, isADEnabled || isNLPEnabled || isDFAEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_ml_footer_item.OverviewFooterItem, {
    icon: "dashboardApp",
    title: _i18n.i18n.translate('xpack.ml.overview.manageMlAssetsTitle', {
      defaultMessage: 'Manage ML Assets'
    }),
    description: _i18n.i18n.translate('xpack.ml.overview.manageMlAssetsDescription', {
      defaultMessage: 'Overview of your ML jobs, memory usage, and notifications.'
    }),
    docLink: helpLink,
    callToAction: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: navigateToStackManagementMLOverview,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 386,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.ml.overview.goToManagmentLink', {
      defaultMessage: 'Go to Management'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 13
    }
  })) : null, isNLPEnabled || isDFAEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_ml_footer_item.OverviewFooterItem, {
    icon: "machineLearningApp",
    title: _i18n.i18n.translate('xpack.ml.overview.trainedModelsTitle', {
      defaultMessage: 'Trained Models'
    }),
    description: _i18n.i18n.translate('xpack.ml.overview.trainedModelsDescription', {
      defaultMessage: 'Add or manage Trained Models. See deployment stats or add a new deployment.'
    }),
    docLink: trainedModelsDocLink,
    callToAction: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: navigateToTrainedModels,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 408,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.ml.overview.manageTrainedModelsLink', {
      defaultMessage: 'Manage Trained Models'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 397,
      columnNumber: 13
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 417,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_ml_footer_item.OverviewFooterItem, {
    icon: "documentation",
    title: _i18n.i18n.translate('xpack.ml.overview.browseDocumentationTitle', {
      defaultMessage: 'Browse documentation'
    }),
    description: _i18n.i18n.translate('xpack.ml.overview.browseDocumentationDescription', {
      defaultMessage: 'In-depth guides on Elastic Machine Learning.'
    }),
    docLink: helpLink,
    callToAction: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: helpLink,
      external: true,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 428,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.ml.overview.startReadingDocsLink', {
      defaultMessage: 'Start Reading'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 418,
      columnNumber: 11
    }
  }))));
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.OverviewPage = OverviewPage;
var _default = exports.default = OverviewPage;