"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useModelActions = useModelActions;
var _i18n = require("@kbn/i18n");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _trained_models = require("@kbn/ml-trained-models-utils/src/constants/trained_models");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _trained_models2 = require("../../../common/types/trained_models");
var _ml = require("../contexts/ml");
var _force_stop_dialog = require("./force_stop_dialog");
var _deployment_setup = require("./deployment_setup");
var _kibana = require("../contexts/kibana");
var _locator = require("../../../common/constants/locator");
var _test_models = require("./test_models");
var _check_capabilities = require("../capabilities/check_capabilities");
var _hooks = require("../components/node_available_warning/hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useModelActions({
  onDfaTestAction,
  onTestAction,
  onModelsDeleteRequest,
  onModelDeployRequest,
  onModelDownloadRequest,
  modelAndDeploymentIds
}) {
  const isMobileLayout = (0, _eui.useIsWithinMaxBreakpoint)('l');
  const isMounted = (0, _useMountedState.default)();
  const {
    services: {
      application: {
        navigateToUrl
      },
      overlays,
      docLinks,
      mlServices: {
        mlApi,
        httpService,
        trainedModelsService,
        mlCapabilities
      },
      ...startServices
    }
  } = (0, _kibana.useMlKibana)();
  const {
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const {
    nlpSettings
  } = (0, _ml.useMlServerInfo)();
  const cloudInfo = (0, _hooks.useCloudCheck)();
  const isLoading = (0, _useObservable.default)(trainedModelsService.isLoading$, trainedModelsService.isLoading);
  const scheduledDeployments = (0, _useObservable.default)(trainedModelsService.scheduledDeployments$, trainedModelsService.scheduledDeployments);
  const [canCreateTrainedModels, canStartStopTrainedModels, canTestTrainedModels, canDeleteTrainedModels] = (0, _check_capabilities.usePermissionCheck)(['canCreateTrainedModels', 'canStartStopTrainedModels', 'canTestTrainedModels', 'canDeleteTrainedModels']);
  const [canManageIngestPipelines, setCanManageIngestPipelines] = (0, _react.useState)(false);
  const startModelDeploymentDocUrl = docLinks.links.ml.startTrainedModelsDeployment;
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const urlLocator = (0, _kibana.useMlLocator)();
  (0, _react.useEffect)(() => {
    mlApi.hasPrivileges({
      cluster: ['manage_ingest_pipelines']
    }).then(result => {
      if (isMounted()) {
        var _result$hasPrivileges;
        setCanManageIngestPipelines(result.hasPrivileges === undefined || ((_result$hasPrivileges = result.hasPrivileges.cluster) === null || _result$hasPrivileges === void 0 ? void 0 : _result$hasPrivileges.manage_ingest_pipelines) === true);
      }
    });
  }, [mlApi, isMounted]);
  const getUserConfirmation = (0, _react.useMemo)(() => (0, _force_stop_dialog.getUserConfirmationProvider)(overlays, startServices), [overlays, startServices]);
  const getUserInputModelDeploymentParams = (0, _react.useMemo)(() => (0, _deployment_setup.getUserInputModelDeploymentParamsProvider)(overlays, startServices, startModelDeploymentDocUrl, cloudInfo, showNodeInfo, nlpSettings, httpService, trainedModelsService, mlCapabilities), [overlays, startServices, startModelDeploymentDocUrl, cloudInfo, showNodeInfo, nlpSettings, httpService, trainedModelsService, mlCapabilities]);
  return (0, _react.useMemo)(() => [{
    name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.viewTrainingDataNameActionLabel', {
      defaultMessage: 'View training data'
    }),
    description: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.viewTrainingDataActionLabel', {
      defaultMessage: 'Training data can be viewed when data frame analytics job exists.'
    }),
    icon: 'visTable',
    type: 'icon',
    available: item => {
      var _item$metadata, _item$metadata$analyt;
      return (0, _trained_models2.isDFAModelItem)(item) && !!((_item$metadata = item.metadata) !== null && _item$metadata !== void 0 && (_item$metadata$analyt = _item$metadata.analytics_config) !== null && _item$metadata$analyt !== void 0 && _item$metadata$analyt.id);
    },
    enabled: item => (0, _trained_models2.isDFAModelItem)(item) && item.origin_job_exists === true,
    onClick: async item => {
      var _item$metadata2, _item$metadata3, _item$metadata4, _item$metadata5;
      if (!(0, _trained_models2.isDFAModelItem)(item) || ((_item$metadata2 = item.metadata) === null || _item$metadata2 === void 0 ? void 0 : _item$metadata2.analytics_config) === undefined) return;
      const analysisType = (0, _mlDataFrameAnalyticsUtils.getAnalysisType)((_item$metadata3 = item.metadata) === null || _item$metadata3 === void 0 ? void 0 : _item$metadata3.analytics_config.analysis);
      const url = await urlLocator.getUrl({
        page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION,
        pageState: {
          jobId: (_item$metadata4 = item.metadata) === null || _item$metadata4 === void 0 ? void 0 : _item$metadata4.analytics_config.id,
          analysisType,
          ...(analysisType === 'classification' || analysisType === 'regression' ? {
            queryText: `${(_item$metadata5 = item.metadata) === null || _item$metadata5 === void 0 ? void 0 : _item$metadata5.analytics_config.dest.results_field}.is_training : true`
          } : {})
        }
      });
      await navigateToUrl(url);
    }
  }, {
    name: _i18n.i18n.translate('xpack.ml.inference.modelsList.analyticsMapActionLabel', {
      defaultMessage: 'Analytics map'
    }),
    description: _i18n.i18n.translate('xpack.ml.inference.modelsList.analyticsMapActionLabel', {
      defaultMessage: 'Analytics map'
    }),
    icon: 'graphApp',
    type: 'icon',
    isPrimary: true,
    available: item => {
      var _item$metadata6, _item$metadata6$analy;
      return (0, _trained_models2.isDFAModelItem)(item) && !!((_item$metadata6 = item.metadata) !== null && _item$metadata6 !== void 0 && (_item$metadata6$analy = _item$metadata6.analytics_config) !== null && _item$metadata6$analy !== void 0 && _item$metadata6$analy.id);
    },
    onClick: async item => {
      const path = await urlLocator.getUrl({
        page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_MAP,
        pageState: {
          modelId: item.model_id
        }
      });
      await navigateToPath(path, false);
    }
  },
  // @ts-expect-error type icon or button is correct
  {
    name: _i18n.i18n.translate('xpack.ml.inference.modelsList.startModelDeploymentActionLabel', {
      defaultMessage: 'Start deployment'
    }),
    description: _i18n.i18n.translate('xpack.ml.inference.modelsList.startModelDeploymentActionDescription', {
      defaultMessage: 'Start deployment'
    }),
    'data-test-subj': 'mlModelsTableRowStartDeploymentAction',
    icon: 'play',
    type: isMobileLayout ? 'icon' : 'button',
    isPrimary: true,
    color: 'success',
    enabled: item => {
      const isModelBeingDeployed = scheduledDeployments.some(deployment => deployment.modelId === item.model_id);
      if ((0, _trained_models2.isModelDownloadItem)(item) && item.state === _trained_models.MODEL_STATE.DOWNLOADED_IN_DIFFERENT_SPACE) {
        return false;
      }
      return canStartStopTrainedModels && !isModelBeingDeployed;
    },
    available: item => {
      return (0, _trained_models2.isNLPModelItem)(item) || canCreateTrainedModels && (0, _trained_models2.isModelDownloadItem)(item) && (item.state === _trained_models.MODEL_STATE.NOT_DOWNLOADED || item.state === _trained_models.MODEL_STATE.DOWNLOADED_IN_DIFFERENT_SPACE);
    },
    onClick: async item => {
      if ((0, _trained_models2.isModelDownloadItem)(item) && item.state === _trained_models.MODEL_STATE.NOT_DOWNLOADED) {
        onModelDownloadRequest(item.model_id);
      }
      const modelDeploymentParams = await getUserInputModelDeploymentParams(item.model_id, undefined, modelAndDeploymentIds);
      if (!modelDeploymentParams) return;
      trainedModelsService.startModelDeployment(item.model_id, modelDeploymentParams);
    }
  }, {
    name: _i18n.i18n.translate('xpack.ml.inference.modelsList.updateModelDeploymentActionLabel', {
      defaultMessage: 'Update deployment'
    }),
    description: _i18n.i18n.translate('xpack.ml.inference.modelsList.updateModelDeploymentActionLabel', {
      defaultMessage: 'Update deployment'
    }),
    'data-test-subj': 'mlModelsTableRowUpdateDeploymentAction',
    icon: 'documentEdit',
    type: 'icon',
    isPrimary: false,
    available: item => {
      var _item$stats, _item$stats$deploymen;
      return (0, _trained_models2.isNLPModelItem)(item) && canStartStopTrainedModels && !isLoading && !!((_item$stats = item.stats) !== null && _item$stats !== void 0 && (_item$stats$deploymen = _item$stats.deployment_stats) !== null && _item$stats$deploymen !== void 0 && _item$stats$deploymen.some(v => v.state === _mlTrainedModelsUtils.DEPLOYMENT_STATE.STARTED));
    },
    onClick: async item => {
      if (!(0, _trained_models2.isNLPModelItem)(item)) return;
      const deploymentIdToUpdate = item.deployment_ids[0];
      const targetDeployment = item.stats.deployment_stats.find(v => v.deployment_id === deploymentIdToUpdate);
      const deploymentParams = await getUserInputModelDeploymentParams(item.model_id, targetDeployment);
      if (!deploymentParams) return;
      trainedModelsService.updateModelDeployment(item.model_id, deploymentParams);
    }
  }, {
    name: _i18n.i18n.translate('xpack.ml.inference.modelsList.stopModelDeploymentActionLabel', {
      defaultMessage: 'Stop deployment'
    }),
    description: _i18n.i18n.translate('xpack.ml.inference.modelsList.stopModelDeploymentActionLabel', {
      defaultMessage: 'Stop deployment'
    }),
    'data-test-subj': 'mlModelsTableRowStopDeploymentAction',
    icon: 'stop',
    type: 'icon',
    isPrimary: false,
    available: item => (0, _trained_models2.isNLPModelItem)(item) && canStartStopTrainedModels && (
    // Deployment can be either started, starting, or exist in a failed state
    item.state === _trained_models.MODEL_STATE.STARTED || item.state === _trained_models.MODEL_STATE.STARTING) && (
    // Only show the action if there is at least one deployment that is not used by the inference service
    !Array.isArray(item.inference_apis) || item.deployment_ids.some(dId => Array.isArray(item.inference_apis) && !item.inference_apis.some(inference => inference.inference_id === dId))),
    enabled: item => !isLoading && !scheduledDeployments.some(d => d.modelId === item.model_id),
    onClick: async item => {
      if (!(0, _trained_models2.isNLPModelItem)(item)) return;
      const requireForceStop = (0, _mlIsPopulatedObject.isPopulatedObject)(item.pipelines);
      const hasMultipleDeployments = item.deployment_ids.length > 1;
      let deploymentIds = item.deployment_ids;
      if (requireForceStop || hasMultipleDeployments) {
        try {
          deploymentIds = await getUserConfirmation(item);
        } catch (error) {
          return;
        }
      }
      trainedModelsService.stopModelDeployment(item.model_id, deploymentIds, {
        force: requireForceStop
      });
    }
  }, {
    name: model => {
      return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.deployModelActionLabel', {
        defaultMessage: 'Deploy model'
      });
    },
    description: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.deployModelActionLabel', {
      defaultMessage: 'Deploy model'
    }),
    'data-test-subj': 'mlModelsTableRowDeployAction',
    icon: 'continuityAbove',
    type: 'icon',
    isPrimary: false,
    onClick: model => {
      onModelDeployRequest(model);
    },
    available: item => {
      return (0, _trained_models2.isDFAModelItem)(item) && canManageIngestPipelines;
    },
    enabled: item => {
      return canStartStopTrainedModels;
    }
  },
  // @ts-expect-error type icon or button is correct
  {
    name: _i18n.i18n.translate('xpack.ml.inference.modelsList.testModelActionLabel', {
      defaultMessage: 'Test'
    }),
    description: _i18n.i18n.translate('xpack.ml.inference.modelsList.testModelActionLabel', {
      defaultMessage: 'Test model'
    }),
    'data-test-subj': 'mlModelsTableRowTestAction',
    icon: 'inputOutput',
    type: isMobileLayout ? 'icon' : 'button',
    isPrimary: true,
    available: item => (0, _test_models.isTestable)(item, true),
    onClick: item => {
      if ((0, _trained_models2.isDFAModelItem)(item)) {
        onDfaTestAction(item);
      } else if ((0, _trained_models2.isExistingModel)(item)) {
        onTestAction(item);
      }
    },
    enabled: item => {
      return canTestTrainedModels && !isLoading;
    }
  }, {
    name: _i18n.i18n.translate('xpack.ml.inference.modelsList.analyzeDataDriftLabel', {
      defaultMessage: 'Analyze data drift'
    }),
    description: _i18n.i18n.translate('xpack.ml.inference.modelsList.analyzeDataDriftLabel', {
      defaultMessage: 'Analyze data drift'
    }),
    'data-test-subj': 'mlModelsAnalyzeDataDriftAction',
    icon: 'visTagCloud',
    type: 'icon',
    isPrimary: true,
    available: item => {
      return (0, _trained_models2.isDFAModelItem)(item) || (0, _trained_models2.isExistingModel)(item) && Array.isArray(item.indices) && item.indices.length > 0;
    },
    onClick: async item => {
      var _item$metadata7, _item$metadata7$analy, _item$metadata7$analy2;
      if (!(0, _trained_models2.isDFAModelItem)(item) || !(0, _trained_models2.isExistingModel)(item)) return;
      let indexPatterns = item.indices;
      if ((0, _trained_models2.isDFAModelItem)(item) && (item === null || item === void 0 ? void 0 : (_item$metadata7 = item.metadata) === null || _item$metadata7 === void 0 ? void 0 : (_item$metadata7$analy = _item$metadata7.analytics_config) === null || _item$metadata7$analy === void 0 ? void 0 : (_item$metadata7$analy2 = _item$metadata7$analy.dest) === null || _item$metadata7$analy2 === void 0 ? void 0 : _item$metadata7$analy2.index) !== undefined) {
        var _item$metadata$analyt2;
        const destIndex = (_item$metadata$analyt2 = item.metadata.analytics_config.dest) === null || _item$metadata$analyt2 === void 0 ? void 0 : _item$metadata$analyt2.index;
        indexPatterns = [destIndex];
      }
      const path = await urlLocator.getUrl({
        page: _locator.ML_PAGES.DATA_DRIFT_CUSTOM,
        pageState: indexPatterns ? {
          comparison: indexPatterns.join(',')
        } : {}
      });
      await navigateToPath(path, false);
    }
  },
  // @ts-expect-error type icon or button is correct
  {
    name: model => {
      return (0, _trained_models2.isModelDownloadItem)(model) && model.state === _trained_models.MODEL_STATE.DOWNLOADING ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.deleteModelActionLabel', {
        defaultMessage: 'Cancel'
      })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.deleteModelActionLabel', {
        defaultMessage: 'Delete model'
      }));
    },
    description: model => {
      if ((0, _trained_models2.isModelDownloadItem)(model) && model.state === _trained_models.MODEL_STATE.DOWNLOADING) {
        return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.cancelDownloadActionLabel', {
          defaultMessage: 'Cancel download'
        });
      } else if ((0, _trained_models2.isNLPModelItem)(model)) {
        var _model$deployment_ids, _model$deployment_ids2;
        const hasDeployments = (_model$deployment_ids = (_model$deployment_ids2 = model.deployment_ids) === null || _model$deployment_ids2 === void 0 ? void 0 : _model$deployment_ids2.length) !== null && _model$deployment_ids !== void 0 ? _model$deployment_ids : 0 > 0;
        const {
          hasInferenceServices
        } = model;
        if (hasInferenceServices) {
          return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.deleteDisabledWithInferenceServicesTooltip', {
            defaultMessage: 'Model is used by the _inference API'
          });
        } else if (hasDeployments) {
          return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.deleteDisabledWithDeploymentsTooltip', {
            defaultMessage: 'Model has started deployments'
          });
        }
      }
      return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.deleteModelActionLabel', {
        defaultMessage: 'Delete model'
      });
    },
    'data-test-subj': 'mlModelsTableRowDeleteAction',
    icon: 'trash',
    type: isMobileLayout ? 'icon' : 'button',
    color: 'danger',
    isPrimary: false,
    onClick: model => {
      onModelsDeleteRequest([model]);
    },
    available: item => {
      if (!canDeleteTrainedModels || (0, _trained_models2.isBuiltInModel)(item)) return false;
      if ((0, _trained_models2.isModelDownloadItem)(item)) {
        return !!item.downloadState;
      } else {
        var _item$pipelines;
        const hasZeroPipelines = Object.keys((_item$pipelines = item.pipelines) !== null && _item$pipelines !== void 0 ? _item$pipelines : {}).length === 0;
        return hasZeroPipelines || canManageIngestPipelines;
      }
    },
    enabled: item => {
      return !(0, _trained_models2.isNLPModelItem)(item) || item.state !== _trained_models.MODEL_STATE.STARTED && item.state !== _trained_models.MODEL_STATE.STARTING;
    }
  }], [isMobileLayout, urlLocator, navigateToUrl, navigateToPath, scheduledDeployments, canStartStopTrainedModels, canCreateTrainedModels, getUserInputModelDeploymentParams, modelAndDeploymentIds, trainedModelsService, onModelDownloadRequest, isLoading, getUserConfirmation, onModelDeployRequest, canManageIngestPipelines, onDfaTestAction, onTestAction, canTestTrainedModels, onModelsDeleteRequest, canDeleteTrainedModels]);
}