"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _codeEditor = require("@kbn/code-editor");
var _constants = require("../../components/ml_inference/constants");
var _validation_utils = require("../../../../common/util/validation_utils");
var _test_trained_models_context = require("../test_models/test_trained_models_context");
var _save_changes_button = require("../../components/ml_inference/components/save_changes_button");
var _validation = require("../../components/ml_inference/validation");
var _shared = require("../../components/shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/create_pipeline_for_model/pipeline_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PipelineDetails = exports.PipelineDetails = /*#__PURE__*/(0, _react.memo)(({
  handlePipelineConfigUpdate,
  modelId,
  pipelineName,
  pipelineNameError,
  pipelineDescription,
  initialPipelineConfig,
  setHasUnsavedChanges,
  taskType
}) => {
  const [isProcessorConfigValid, setIsProcessorConfigValid] = (0, _react.useState)(true);
  const [processorConfigError, setProcessorConfigError] = (0, _react.useState)();
  const {
    currentContext: {
      pipelineConfig
    }
  } = (0, _test_trained_models_context.useTestTrainedModelsContext)();
  const [processorConfigString, setProcessorConfigString] = (0, _react.useState)(JSON.stringify(initialPipelineConfig !== null && initialPipelineConfig !== void 0 ? initialPipelineConfig : {}, null, 2));
  const [editProcessorConfig, setEditProcessorConfig] = (0, _react.useState)(false);
  const updateProcessorConfig = () => {
    const invalidProcessorConfigMessage = (0, _validation.validatePipelineProcessors)(JSON.parse(processorConfigString), taskType);
    if (invalidProcessorConfigMessage === undefined) {
      handlePipelineConfigUpdate({
        initialPipelineConfig: JSON.parse(processorConfigString)
      });
      setHasUnsavedChanges(false);
      setEditProcessorConfig(false);
      setProcessorConfigError(undefined);
    } else {
      setHasUnsavedChanges(true);
      setIsProcessorConfigValid(false);
      setProcessorConfigError(invalidProcessorConfigMessage);
    }
  };
  const handleProcessorConfigChange = json => {
    setProcessorConfigString(json);
    const valid = (0, _validation_utils.isValidJson)(json);
    setIsProcessorConfigValid(valid);
  };
  const resetProcessorConfig = () => {
    setProcessorConfigString(JSON.stringify(pipelineConfig, null, 2));
    setIsProcessorConfigValid(true);
    setProcessorConfigError(undefined);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.PipelineDetailsTitle, {
    modelId: modelId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.PipelineNameAndDescription, {
    pipelineName: pipelineName,
    pipelineDescription: pipelineDescription,
    pipelineNameError: pipelineNameError,
    handlePipelineConfigUpdate: handlePipelineConfigUpdate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "mlTrainedModelsInferencePipelineInferenceConfigEditButton",
      iconType: "pencil",
      size: "xs",
      onClick: () => {
        const editingState = !editProcessorConfig;
        if (editingState === false) {
          setProcessorConfigError(undefined);
          setIsProcessorConfigValid(true);
          setHasUnsavedChanges(false);
        }
        setEditProcessorConfig(editingState);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 23
      }
    }, editProcessorConfig ? _constants.CANCEL_EDIT_MESSAGE : _constants.EDIT_MESSAGE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 21
      }
    }, editProcessorConfig ? /*#__PURE__*/_react.default.createElement(_save_changes_button.SaveChangesButton, {
      onClick: updateProcessorConfig,
      disabled: isProcessorConfigValid === false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 25
      }
    }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 21
      }
    }, editProcessorConfig ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: resetProcessorConfig,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 25
      }
    }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.resetInferenceConfigButton', {
      defaultMessage: 'Reset'
    })) : null)),
    error: processorConfigError,
    isInvalid: processorConfigError !== undefined,
    "data-test-subj": "mlTrainedModelsInferencePipelineInferenceConfigEditor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  }, editProcessorConfig ? /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    height: 300,
    languageId: "json",
    options: {
      automaticLayout: true,
      lineNumbers: 'off',
      tabSize: 2
    },
    value: processorConfigString,
    onChange: handleProcessorConfigChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    "data-test-subj": "mlTrainedModelsInferencePipelineInferenceConfigBlock",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 19
    }
  }, processorConfigString))))));
});