"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useThresholdToSeverity = void 0;
var _react = require("react");
var _use_severity_options = require("./use_severity_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * React hook that returns a function to find severity options by threshold values
 * @returns A function that converts threshold objects to severity options
 */
const useThresholdToSeverity = () => {
  const severityOptions = (0, _use_severity_options.useSeverityOptions)();
  return (0, _react.useCallback)(thresholds => {
    // Get corresponding severity objects that match the thresholds
    const matchingSeverities = severityOptions.filter(severity => thresholds.some(threshold => threshold.min === severity.threshold.min && threshold.max === severity.threshold.max));

    // Default to lowest severity if no matches found
    if (matchingSeverities.length === 0) {
      return [severityOptions[0]];
    }
    return matchingSeverities;
  }, [severityOptions]);
};
exports.useThresholdToSeverity = useThresholdToSeverity;