"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExplorerChartTooltipStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("react");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useExplorerChartTooltipStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const euiFontSizeXS = (0, _eui.useEuiFontSize)('xs').fontSize;
  return (0, _react.useMemo)(() => ({
    tooltip: (0, _react2.css)({
      maxWidth: '384px'
    }),
    descriptionList: (0, _react2.css)({
      display: 'grid',
      gridTemplateColumns: 'max-content auto',
      '& > *': {
        marginTop: euiTheme.size.xs
      }
    }),
    title: (0, _react2.css)({
      color: euiTheme.colors.ghost,
      fontSize: euiFontSizeXS,
      fontWeight: 'normal',
      whiteSpace: 'nowrap',
      gridColumnStart: 1
    }),
    description: (0, _react2.css)({
      color: euiTheme.colors.ghost,
      fontSize: euiFontSizeXS,
      fontWeight: 'bold',
      paddingLeft: euiTheme.size.s,
      maxWidth: '256px',
      gridColumnStart: 2
    }),
    chartDescription: (0, _react2.css)({
      fontSize: euiFontSizeXS,
      fontStyle: 'italic'
    })
  }), [euiFontSizeXS, euiTheme]);
};
exports.useExplorerChartTooltipStyles = useExplorerChartTooltipStyles;