"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationTimeline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _d = _interopRequireDefault(require("d3"));
var _d3Scale = require("d3-scale");
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/annotation_timeline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ANNOTATION_CONTAINER_HEIGHT = 12;
const ANNOTATION_MIN_WIDTH = 8;

/**
 * Reusable component for rendering annotation-like items on a timeline.
 */
const AnnotationTimeline = ({
  data,
  domain,
  label,
  tooltipService,
  chartWidth,
  getTooltipContent
}) => {
  const canvasRef = _react.default.useRef(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const euiFontSizeXS = (0, _eui.useEuiFontSize)('xs', {
    unit: 'px'
  }).fontSize;
  (0, _react.useEffect)(function renderChart() {
    if (!(canvasRef.current !== null && Array.isArray(data))) return;
    const chartElement = _d.default.select(canvasRef.current);
    chartElement.selectAll('*').remove();
    const dimensions = canvasRef.current.getBoundingClientRect();
    const startingXPos = _constants.Y_AXIS_LABEL_WIDTH;
    const endingXPos = dimensions.width;
    const svg = chartElement.append('svg').attr('width', '100%').attr('height', ANNOTATION_CONTAINER_HEIGHT);
    const xScale = (0, _d3Scale.scaleTime)().domain([domain.min, domain.max]).range([startingXPos, endingXPos]);

    // Add Annotation y axis label
    svg.append('text').attr('text-anchor', 'end').attr('class', 'swimlaneAnnotationLabel').text(label).attr('x', _constants.Y_AXIS_LABEL_WIDTH - _constants.Y_AXIS_LABEL_PADDING).attr('y', ANNOTATION_CONTAINER_HEIGHT / 2).attr('dominant-baseline', 'middle').style('fill', euiTheme.colors.textSubdued).style('font-size', euiFontSizeXS);

    // Add border
    svg.append('rect').attr('x', startingXPos).attr('y', 0).attr('height', ANNOTATION_CONTAINER_HEIGHT).attr('width', endingXPos - startingXPos).style('stroke', euiTheme.border.color).style('fill', 'none').style('stroke-width', 1);

    // Merging overlapping annotations into bigger blocks
    let mergedAnnotations = [];
    const sortedAnnotationsData = [...data].sort((a, b) => a.timestamp - b.timestamp);
    if (sortedAnnotationsData.length > 0) {
      var _sortedAnnotationsDat;
      let lastEndTime = (_sortedAnnotationsDat = sortedAnnotationsData[0].end_timestamp) !== null && _sortedAnnotationsDat !== void 0 ? _sortedAnnotationsDat : sortedAnnotationsData[0].timestamp;
      mergedAnnotations = [{
        start: sortedAnnotationsData[0].timestamp,
        end: lastEndTime,
        annotations: [sortedAnnotationsData[0]]
      }];
      for (let i = 1; i < sortedAnnotationsData.length; i++) {
        if (sortedAnnotationsData[i].timestamp < lastEndTime) {
          const itemToMerge = mergedAnnotations.pop();
          if (itemToMerge) {
            const newMergedItem = {
              ...itemToMerge,
              end: lastEndTime,
              annotations: [...itemToMerge.annotations, sortedAnnotationsData[i]]
            };
            mergedAnnotations.push(newMergedItem);
          }
        } else {
          var _sortedAnnotationsDat2;
          lastEndTime = (_sortedAnnotationsDat2 = sortedAnnotationsData[i].end_timestamp) !== null && _sortedAnnotationsDat2 !== void 0 ? _sortedAnnotationsDat2 : sortedAnnotationsData[i].timestamp;
          mergedAnnotations.push({
            start: sortedAnnotationsData[i].timestamp,
            end: lastEndTime,
            annotations: [sortedAnnotationsData[i]]
          });
        }
      }
    }

    // Add annotation marker
    mergedAnnotations.forEach(mergedAnnotation => {
      const annotationWidth = Math.max(mergedAnnotation.end ? xScale(Math.min(mergedAnnotation.end, domain.max)) - Math.max(xScale(mergedAnnotation.start), startingXPos) : 0, ANNOTATION_MIN_WIDTH);
      const xPos = mergedAnnotation.start >= domain.min ? xScale(mergedAnnotation.start) : startingXPos;
      svg.append('rect').classed('ml-annotation__rect', true)
      // If annotation is at the end, prevent overflow by shifting it back
      .attr('x', xPos + annotationWidth >= endingXPos ? endingXPos - annotationWidth : xPos).attr('y', 0).attr('height', ANNOTATION_CONTAINER_HEIGHT).attr('width', annotationWidth).on('mouseover', function () {
        let tooltipData = [];
        if (Array.isArray(mergedAnnotation.annotations)) {
          const hasMergedAnnotations = mergedAnnotation.annotations.length > 1;
          if (hasMergedAnnotations) {
            // @ts-ignore skipping header so it doesn't have other params
            tooltipData.push({
              skipHeader: true
            });
          }
          tooltipData = [...tooltipData, ...mergedAnnotation.annotations.map(item => getTooltipContent(item, hasMergedAnnotations)).flat()];
        }
        tooltipService.show(tooltipData, this);
      }).on('mouseout', () => tooltipService.hide());
    });
  }, [chartWidth, domain, data, tooltipService, label, euiTheme, euiFontSizeXS, getTooltipContent]);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: canvasRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 10
    }
  });
};
exports.AnnotationTimeline = AnnotationTimeline;