"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexDataVisualizerPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _eui = require("@elastic/eui");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _kibana = require("../../contexts/kibana");
var _help_menu = require("../../components/help_menu");
var _locator = require("../../../../common/constants/locator");
var _license = require("../../license");
var _check_ml_nodes = require("../../ml_nodes_check/check_ml_nodes");
var _check_capabilities = require("../../capabilities/check_capabilities");
var _page_header = require("../../components/page_header");
var _ml = require("../../contexts/ml");
var _technical_preview_badge = require("../../components/technical_preview_badge");
var _use_create_url = require("../../contexts/kibana/use_create_url");
var _page_title = require("../../components/page_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/datavisualizer/index_based/index_data_visualizer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndexDataVisualizerPage = ({
  esql = false
}) => {
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  const {
    services: {
      docLinks,
      dataVisualizer,
      data: {
        dataViews: {
          get: getDataView
        }
      },
      mlServices: {
        mlApi: {
          recognizeIndex
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const mlApi = (0, _kibana.useMlApi)();
  const {
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const mlLocator = (0, _kibana.useMlLocator)();
  const mlManagementLocator = (0, _use_create_url.useMlManagementLocator)();
  const mlFeaturesDisabled = !(0, _license.isFullLicense)();
  (0, _check_ml_nodes.getMlNodeCount)(mlApi);
  const [IndexDataVisualizer, setIndexDataVisualizer] = (0, _react.useState)(null);
  const isMounted = (0, _useMountedState.default)();
  (0, _react.useEffect)(() => {
    if (dataVisualizer !== undefined) {
      const {
        getIndexDataVisualizerComponent
      } = dataVisualizer;
      getIndexDataVisualizerComponent().then(component => {
        if (isMounted()) {
          setIndexDataVisualizer(component);
        }
      });
    }

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const getAsyncMLCards = async ({
    dataViewId,
    dataViewTitle,
    globalState
  }) => {
    return [{
      id: 'create_ml_ad_job',
      title: _i18n.i18n.translate('xpack.ml.indexDatavisualizer.actionsPanel.anomalyDetectionTitle', {
        defaultMessage: 'Advanced anomaly detection'
      }),
      description: _i18n.i18n.translate('xpack.ml.indexDatavisualizer.actionsPanel.anomalyDetectionDescription', {
        defaultMessage: 'Create a job with the full range of options for more advanced use cases.'
      }),
      icon: 'createAdvancedJob',
      type: 'file',
      getUrl: async () => {
        var _await$mlManagementLo;
        return (_await$mlManagementLo = await (mlManagementLocator === null || mlManagementLocator === void 0 ? void 0 : mlManagementLocator.getRedirectUrl({
          sectionId: 'ml',
          appId: `anomaly_detection/${_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_ADVANCED}?index=${dataViewId}`
        }))) !== null && _await$mlManagementLo !== void 0 ? _await$mlManagementLo : '';
      },
      canDisplay: async () => {
        try {
          const {
            timeFieldName
          } = await getDataView(dataViewId);
          return (0, _license.isFullLicense)() && timeFieldName !== undefined && (0, _check_capabilities.checkPermission)('canCreateJob') && (0, _check_ml_nodes.mlNodesAvailable)();
        } catch (error) {
          return false;
        }
      },
      'data-test-subj': 'dataVisualizerCreateAdvancedJobCard'
    }, {
      id: 'create_ml_dfa_job',
      title: _i18n.i18n.translate('xpack.ml.indexDatavisualizer.actionsPanel.dataframeTitle', {
        defaultMessage: 'Data frame analytics'
      }),
      description: _i18n.i18n.translate('xpack.ml.indexDatavisualizer.actionsPanel.dataframeDescription', {
        defaultMessage: 'Create outlier detection, regression, or classification analytics.'
      }),
      icon: 'classificationJob',
      type: 'file',
      getUrl: async () => {
        var _await$mlManagementLo2;
        if (!mlManagementLocator) return '';
        return (_await$mlManagementLo2 = await (mlManagementLocator === null || mlManagementLocator === void 0 ? void 0 : mlManagementLocator.getRedirectUrl({
          sectionId: 'ml',
          appId: `analytics/${_locator.ML_PAGES.DATA_FRAME_ANALYTICS_CREATE_JOB}?index=${dataViewId}`
        }))) !== null && _await$mlManagementLo2 !== void 0 ? _await$mlManagementLo2 : '';
      },
      canDisplay: async () => {
        return (0, _license.isFullLicense)() && (0, _check_capabilities.checkPermission)('canCreateDataFrameAnalytics') && (0, _check_ml_nodes.mlNodesAvailable)();
      },
      'data-test-subj': 'dataVisualizerCreateDataFrameAnalyticsCard'
    }];
  };
  const getAsyncRecognizedModuleCards = async params => {
    const {
      dataViewId,
      dataViewTitle
    } = params;
    try {
      const modules = await recognizeIndex({
        indexPatternTitle: dataViewTitle
      });
      return modules === null || modules === void 0 ? void 0 : modules.map(m => {
        var _m$logo$icon, _m$logo;
        return {
          id: m.id,
          title: m.title,
          description: m.description,
          icon: (_m$logo$icon = (_m$logo = m.logo) === null || _m$logo === void 0 ? void 0 : _m$logo.icon) !== null && _m$logo$icon !== void 0 ? _m$logo$icon : '',
          type: 'index',
          getUrl: async () => {
            var _await$mlManagementLo3;
            return (_await$mlManagementLo3 = await (mlManagementLocator === null || mlManagementLocator === void 0 ? void 0 : mlManagementLocator.getRedirectUrl({
              sectionId: 'ml',
              appId: `anomaly_detection/${_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_RECOGNIZER}?id=${m.id}&index=${dataViewId}`
            }))) !== null && _await$mlManagementLo3 !== void 0 ? _await$mlManagementLo3 : '';
          },
          canDisplay: async () => {
            try {
              const {
                timeFieldName
              } = await getDataView(dataViewId);
              return (0, _license.isFullLicense)() && timeFieldName !== undefined && (0, _check_capabilities.checkPermission)('canCreateJob') && (0, _check_ml_nodes.mlNodesAvailable)();
            } catch (error) {
              return false;
            }
          },
          'data-test-subj': m.id
        };
      });
    } catch (error) {
      // eslint-disable-next-line no-console
      console.error('Platinum, Enterprise or trial license needed');
      return [];
    }
  };
  const getAdditionalLinks = (0, _react.useMemo)(() => mlFeaturesDisabled ? [] : [getAsyncRecognizedModuleCards, getAsyncMLCards],
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [mlLocator, mlFeaturesDisabled]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return IndexDataVisualizer ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 5
    }
  }, IndexDataVisualizer !== null ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataVisualizer.pageHeader",
      defaultMessage: "Data Visualizer",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 15
    }
  }), esql ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.datavisualizer",
    defaultMessage: "(ES|QL)",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      marginTop: euiTheme.size.xs
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 21
    }
  }))) : null)), /*#__PURE__*/_react.default.createElement(IndexDataVisualizer, {
    getAdditionalLinks: getAdditionalLinks,
    showFrozenDataTierChoice: showNodeInfo,
    esql: esql,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: docLinks.links.ml.guide,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 5
    }
  });
};
exports.IndexDataVisualizerPage = IndexDataVisualizerPage;