"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/components/error_callout/error_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ErrorCallout = ({
  error
}) => {
  let errorCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.errorCallout.generalErrorTitle', {
      defaultMessage: 'An error occurred loading the data.'
    }),
    color: "danger",
    iconType: "cross",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }, error));
  // Job was created but not started so the destination index has not been created
  if (typeof error === 'string' && error.includes('index_not_found')) {
    errorCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.errorCallout.evaluateErrorTitle', {
        defaultMessage: 'An error occurred loading the data.'
      }),
      color: "danger",
      iconType: "cross",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.errorCallout.noIndexCalloutBody', {
      defaultMessage: 'The query for the index returned no results. Please make sure the destination index exists and contains documents.'
    })));
  } else if (typeof error === 'string' && error.includes('No documents found')) {
    // Job was started but no results have been written yet
    errorCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.errorCallout.noDataCalloutTitle', {
        defaultMessage: 'Empty index query result.'
      }),
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.errorCallout.noDataCalloutBody', {
      defaultMessage: 'The query for the index returned no results. Please make sure the job has completed and the index contains documents.'
    })));
  } else if (typeof error === 'string' && error.includes('userProvidedQueryBuilder')) {
    // query bar syntax is incorrect
    errorCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.errorCallout.queryParsingErrorTitle', {
        defaultMessage: 'Unable to parse query.'
      }),
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.errorCallout.queryParsingErrorBody', {
      defaultMessage: 'The query syntax is invalid and returned no results. Please check the query syntax and try again.'
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 10
    }
  }, errorCallout);
};
exports.ErrorCallout = ErrorCallout;