"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertFieldNameMap = exports.TOP_N_BUCKETS_COUNT = exports.ML_VALID_CONSUMERS = exports.ML_RULE_TYPE_IDS = exports.ML_ALERT_TYPES = exports.HEALTH_CHECK_NAMES = exports.ANOMALY_RESULT_TYPE_SCORE_FIELDS = exports.ALL_JOBS_SELECTION = exports.ALERT_TOP_RECORDS = exports.ALERT_TOP_INFLUENCERS = exports.ALERT_PREVIEW_SAMPLE_SIZE = exports.ALERT_MML_RESULTS = exports.ALERT_JOB_ERRORS_RESULTS = exports.ALERT_DELAYED_DATA_RESULTS = exports.ALERT_DATAFEED_RESULTS = exports.ALERT_ANOMALY_TIMESTAMP = exports.ALERT_ANOMALY_SCORE = exports.ALERT_ANOMALY_IS_INTERIM = exports.ALERT_ANOMALY_DETECTION_JOB_ID = void 0;
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ML_ALERT_TYPES = exports.ML_ALERT_TYPES = {
  ANOMALY_DETECTION: _ruleDataUtils.ML_ANOMALY_DETECTION_RULE_TYPE_ID,
  AD_JOBS_HEALTH: 'xpack.ml.anomaly_detection_jobs_health'
};
const ML_RULE_TYPE_IDS = exports.ML_RULE_TYPE_IDS = Object.values(ML_ALERT_TYPES);
const ML_VALID_CONSUMERS = exports.ML_VALID_CONSUMERS = [_ruleDataUtils.AlertConsumers.ML, _ruleDataUtils.AlertConsumers.ALERTS, _ruleDataUtils.AlertConsumers.STACK_ALERTS];
const ALERT_PREVIEW_SAMPLE_SIZE = exports.ALERT_PREVIEW_SAMPLE_SIZE = 5;
const TOP_N_BUCKETS_COUNT = exports.TOP_N_BUCKETS_COUNT = 1;
const ALL_JOBS_SELECTION = exports.ALL_JOBS_SELECTION = '*';
const HEALTH_CHECK_NAMES = exports.HEALTH_CHECK_NAMES = {
  datafeed: {
    name: _i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.datafeedCheckName', {
      defaultMessage: 'Datafeed is not started'
    }),
    description: _i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.datafeedCheckDescription', {
      defaultMessage: 'Get alerted if the corresponding datafeed of the job is not started'
    })
  },
  mml: {
    name: _i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.mmlCheckName', {
      defaultMessage: 'Model memory limit reached'
    }),
    description: _i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.mmlCheckDescription', {
      defaultMessage: 'Get alerted when job reaches soft or hard model memory limit.'
    })
  },
  delayedData: {
    name: _i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.delayedDataCheckName', {
      defaultMessage: 'Data delay has occurred'
    }),
    description: _i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.delayedDataCheckDescription', {
      defaultMessage: 'Get alerted if a job missed data due to data delay.'
    })
  },
  errorMessages: {
    name: _i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.errorMessagesCheckName', {
      defaultMessage: 'Errors in job messages'
    }),
    description: _i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.errorMessagesCheckDescription', {
      defaultMessage: 'Get alerted if a job contains errors in the job messages.'
    })
  },
  behindRealtime: {
    name: _i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.behindRealtimeCheckName', {
      defaultMessage: 'Job is running behind real-time'
    }),
    description: _i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.behindRealtimeCheckDescription', {
      defaultMessage: 'Job is running behind real-time'
    })
  }
};
const ML_ALERT_NAMESPACE = _ruleDataUtils.ALERT_NAMESPACE;

// Anomaly detection rule type fields
const ALERT_ANOMALY_TIMESTAMP = exports.ALERT_ANOMALY_TIMESTAMP = `${ML_ALERT_NAMESPACE}.anomaly_timestamp`;
const ALERT_ANOMALY_DETECTION_JOB_ID = exports.ALERT_ANOMALY_DETECTION_JOB_ID = `${ML_ALERT_NAMESPACE}.job_id`;
const ALERT_ANOMALY_SCORE = exports.ALERT_ANOMALY_SCORE = `${ML_ALERT_NAMESPACE}.anomaly_score`;
const ALERT_ANOMALY_IS_INTERIM = exports.ALERT_ANOMALY_IS_INTERIM = `${ML_ALERT_NAMESPACE}.is_interim`;
const ALERT_TOP_RECORDS = exports.ALERT_TOP_RECORDS = `${ML_ALERT_NAMESPACE}.top_records`;
const ALERT_TOP_INFLUENCERS = exports.ALERT_TOP_INFLUENCERS = `${ML_ALERT_NAMESPACE}.top_influencers`;
const ANOMALY_RESULT_TYPE_SCORE_FIELDS = exports.ANOMALY_RESULT_TYPE_SCORE_FIELDS = {
  [_mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.BUCKET]: 'anomaly_score',
  [_mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.RECORD]: 'record_score',
  [_mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.INFLUENCER]: 'influencer_score'
};

// Anomaly detection health rule type fields
const ALERT_MML_RESULTS = exports.ALERT_MML_RESULTS = `${ML_ALERT_NAMESPACE}.mml_results`;
const ALERT_DATAFEED_RESULTS = exports.ALERT_DATAFEED_RESULTS = `${ML_ALERT_NAMESPACE}.datafeed_results`;
const ALERT_DELAYED_DATA_RESULTS = exports.ALERT_DELAYED_DATA_RESULTS = `${ML_ALERT_NAMESPACE}.delayed_data_results`;
const ALERT_JOB_ERRORS_RESULTS = exports.ALERT_JOB_ERRORS_RESULTS = `${ML_ALERT_NAMESPACE}.job_errors_results`;
const alertFieldNameMap = exports.alertFieldNameMap = Object.freeze({
  [_ruleDataUtils.ALERT_RULE_NAME]: _i18n.i18n.translate('xpack.ml.alertsTable.columns.ruleName', {
    defaultMessage: 'Rule name'
  }),
  [_ruleDataUtils.ALERT_STATUS]: _i18n.i18n.translate('xpack.ml.alertsTable.columns.status', {
    defaultMessage: 'Status'
  }),
  [ALERT_ANOMALY_DETECTION_JOB_ID]: _i18n.i18n.translate('xpack.ml.alertsTable.columns.jobId', {
    defaultMessage: 'Job ID'
  }),
  [ALERT_ANOMALY_SCORE]: _i18n.i18n.translate('xpack.ml.alertsTable.columns.anomalyScore', {
    defaultMessage: 'Latest anomaly score'
  }),
  [ALERT_ANOMALY_TIMESTAMP]: _i18n.i18n.translate('xpack.ml.alertsTable.columns.anomalyTime', {
    defaultMessage: 'Latest anomaly time'
  }),
  [_ruleDataUtils.ALERT_DURATION]: _i18n.i18n.translate('xpack.ml.alertsTable.columns.duration', {
    defaultMessage: 'Duration'
  }),
  [_ruleDataUtils.ALERT_START]: _i18n.i18n.translate('xpack.ml.alertsTable.columns.start', {
    defaultMessage: 'Start time'
  })
});