"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateDataViewForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _create_data_view_switch = require("./create_data_view_switch");
var _create_data_view_time_field = require("./create_data_view_time_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/packages/private/ml/data_view_utils/components/create_data_view_form_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CreateDataViewForm = ({
  canCreateDataView,
  createDataView,
  dataViewTitleExists,
  setCreateDataView,
  dataViewAvailableTimeFields,
  dataViewTimeField,
  onTimeFieldChanged
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  isInvalid: createDataView && dataViewTitleExists || canCreateDataView === false,
  error: [...(canCreateDataView === false ? [/*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.ml.dataViewUtils.dataViewPermissionWarning', {
    defaultMessage: 'You need permission to create data views.'
  }))] : []), ...(createDataView && dataViewTitleExists ? [_i18n.i18n.translate('xpack.ml.dataViewUtils.dataViewTitleError', {
    defaultMessage: 'A data view with this title already exists.'
  })] : [])],
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 37,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_create_data_view_switch.CreateDataViewSwitch, {
  canCreateDataView: canCreateDataView,
  createDataView: createDataView,
  setCreateDataView: setCreateDataView,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 58,
    columnNumber: 7
  }
})), createDataView && !dataViewTitleExists && dataViewAvailableTimeFields.length > 0 && /*#__PURE__*/_react.default.createElement(_create_data_view_time_field.CreateDataViewTimeField, {
  dataViewAvailableTimeFields: dataViewAvailableTimeFields,
  dataViewTimeField: dataViewTimeField,
  onTimeFieldChanged: onTimeFieldChanged,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 65,
    columnNumber: 7
  }
}));
exports.CreateDataViewForm = CreateDataViewForm;