"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.numberValidator = numberValidator;
var _lodash = require("lodash");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Represents the result of number validation.
 * @interface
 */

/**
 * An interface describing conditions for validating numbers.
 * @interface
 */

/**
 * Validate if a number is within specified minimum and maximum bounds.
 *
 * @param conditions - An optional object containing validation conditions.
 * @returns validation results.
 * @throws {Error} If the provided conditions are invalid (min is greater than max).
 */
function numberValidator(conditions) {
  if ((conditions === null || conditions === void 0 ? void 0 : conditions.min) !== undefined && conditions.max !== undefined && conditions.min > conditions.max) {
    throw new Error('Invalid validator conditions');
  }
  return (0, _lodash.memoize)(value => {
    const result = {};
    if (value === undefined) {
      if (conditions !== null && conditions !== void 0 && conditions.required) {
        result.required = true;
        return result;
      } else {
        return null;
      }
    }
    if ((conditions === null || conditions === void 0 ? void 0 : conditions.min) !== undefined && value < conditions.min) {
      result.min = true;
    }
    if ((conditions === null || conditions === void 0 ? void 0 : conditions.max) !== undefined && value > conditions.max) {
      result.max = true;
    }
    if (!!(conditions !== null && conditions !== void 0 && conditions.integerOnly) && !Number.isInteger(value)) {
      result.integerOnly = true;
    }
    if ((0, _mlIsPopulatedObject.isPopulatedObject)(result)) {
      return result;
    }
    return null;
  });
}