"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildMetricField = buildMetricField;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function buildMetricField({
  name,
  index,
  dimensions,
  type,
  typeInfo
}) {
  var _typeInfo$meta, _typeInfo$meta2, _typeInfo$meta3, _typeInfo$meta4;
  const unit = Array.isArray((_typeInfo$meta = typeInfo.meta) === null || _typeInfo$meta === void 0 ? void 0 : _typeInfo$meta.unit) ? typeInfo.meta.unit.join(', ') : (_typeInfo$meta2 = typeInfo.meta) === null || _typeInfo$meta2 === void 0 ? void 0 : _typeInfo$meta2.unit;
  const display = Array.isArray((_typeInfo$meta3 = typeInfo.meta) === null || _typeInfo$meta3 === void 0 ? void 0 : _typeInfo$meta3.display) ? typeInfo.meta.display.join(', ') : (_typeInfo$meta4 = typeInfo.meta) === null || _typeInfo$meta4 === void 0 ? void 0 : _typeInfo$meta4.display;
  return {
    name,
    index,
    dimensions,
    type,
    instrument: typeInfo.time_series_metric,
    unit,
    display
  };
}