"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pod = void 0;
var _i18n = require("@kbn/i18n");
var _metrics = require("./metrics");
var _create_inventory_model = require("../../shared/create_inventory_model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pod = exports.pod = (0, _create_inventory_model.createInventoryModel)('pod', {
  displayName: _i18n.i18n.translate('xpack.metricsData.inventoryModel.pod.displayName', {
    defaultMessage: 'Kubernetes Pods'
  }),
  singularDisplayName: _i18n.i18n.translate('xpack.metricsData.inventoryModels.pod.singularDisplayName', {
    defaultMessage: 'Kubernetes Pod'
  }),
  requiredIntegration: {
    beats: 'kubernetes',
    otel: 'kubeletstatsreceiver.otel'
  },
  crosslinkSupport: {
    details: true,
    logs: true,
    apm: true,
    uptime: true
  },
  fields: {
    id: 'kubernetes.pod.uid',
    name: 'kubernetes.pod.name',
    ip: 'kubernetes.pod.ip'
  },
  metrics: _metrics.metrics,
  nodeFilter: () => [{
    term: {
      'event.module': 'kubernetes'
    }
  }]
});