"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.init = void 0;
var _constants = require("../../../shared/charts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const init = formulas => {
  var _formulas$get$label, _formulas$get$label2, _formulas$get$label3, _formulas$get$label4;
  const cpuUsageBreakdown = {
    id: 'cpuUsageBreakdown',
    chartType: 'xy',
    title: _constants.CPU_USAGE_LABEL,
    layers: [{
      seriesType: 'area',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [formulas.get('cpuUsageIowait'), formulas.get('cpuUsageIrq'), formulas.get('cpuUsageNice'), formulas.get('cpuUsageSoftirq'), formulas.get('cpuUsageSteal'), formulas.get('cpuUsageUser'), formulas.get('cpuUsageSystem')]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    legend: {
      ..._constants.DEFAULT_XY_LEGEND.legend,
      legendStats: _constants.DEFAULT_LEGEND_STATS
    },
    ..._constants.DEFAULT_XY_YBOUNDS,
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const loadBreakdown = {
    id: 'loadBreakdown',
    chartType: 'xy',
    title: _constants.LOAD_LABEL,
    layers: [{
      seriesType: 'area',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [formulas.get('load1m'), formulas.get('load5m'), formulas.get('load15m')]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    legend: {
      ..._constants.DEFAULT_XY_LEGEND.legend,
      legendStats: _constants.DEFAULT_LEGEND_STATS
    },
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const cpuUsageXY = {
    id: 'cpuUsage',
    chartType: 'xy',
    title: (_formulas$get$label = formulas.get('cpuUsage').label) !== null && _formulas$get$label !== void 0 ? _formulas$get$label : '',
    layers: [{
      seriesType: 'line',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [formulas.get('cpuUsage')]
    }, {
      type: 'reference',
      yAxis: [{
        value: '1'
      }]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    legend: {
      ..._constants.DEFAULT_XY_LEGEND.legend,
      legendStats: _constants.DEFAULT_LEGEND_STATS
    },
    ..._constants.DEFAULT_XY_YBOUNDS,
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const normalizedLoad1mXY = {
    id: 'normalizedLoad1m',
    chartType: 'xy',
    title: (_formulas$get$label2 = formulas.get('normalizedLoad1m').label) !== null && _formulas$get$label2 !== void 0 ? _formulas$get$label2 : '',
    layers: [{
      seriesType: 'line',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [formulas.get('normalizedLoad1m')]
    }, {
      type: 'reference',
      yAxis: [{
        value: '1'
      }]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    legend: {
      ..._constants.DEFAULT_XY_LEGEND.legend,
      legendStats: _constants.DEFAULT_LEGEND_STATS
    },
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const cpuUsageMetric = {
    id: 'cpuUsage',
    chartType: 'metric',
    title: (_formulas$get$label3 = formulas.get('cpuUsage').label) !== null && _formulas$get$label3 !== void 0 ? _formulas$get$label3 : '',
    trendLine: true,
    ...formulas.get('cpuUsage')
  };
  const normalizedLoad1mMetric = {
    id: 'normalizedLoad1m',
    chartType: 'metric',
    title: (_formulas$get$label4 = formulas.get('normalizedLoad1m').label) !== null && _formulas$get$label4 !== void 0 ? _formulas$get$label4 : '',
    trendLine: true,
    ...formulas.get('normalizedLoad1m')
  };
  return {
    xy: {
      cpuUsageBreakdown,
      loadBreakdown,
      cpuUsage: cpuUsageXY,
      normalizedLoad1m: normalizedLoad1mXY
    },
    metric: {
      cpuUsage: cpuUsageMetric,
      normalizedLoad1m: normalizedLoad1mMetric
    }
  };
};
exports.init = init;