"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.monitoringCollectionSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Configuration of the plugin `monitoring_collection`
 */

/**
 * Config schema of the plugin `monitoring_collection`.
 * @privateRemarks It needs to be defined here because it declares the configuration of some Metric Exporters,
 * and importing the config from the plugin would create a circular dependency.
 */
const monitoringCollectionSchema = exports.monitoringCollectionSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  opentelemetry: _configSchema.schema.object({
    metrics: _configSchema.schema.object({
      otlp: _configSchema.schema.object({
        url: _configSchema.schema.maybe(_configSchema.schema.string()),
        headers: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string())),
        exportIntervalMillis: _configSchema.schema.number({
          defaultValue: 10000
        }),
        logLevel: _configSchema.schema.string({
          defaultValue: 'info'
        })
      }),
      prometheus: _configSchema.schema.object({
        enabled: _configSchema.schema.boolean({
          defaultValue: false
        })
      })
    })
  })
});