"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.joinSourceSchema = exports.ESTermSourceSchema = exports.ESJoinSourceSchema = exports.ESDistanceSourceSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _esQueryServer = require("@kbn/es-query-server");
var _common = require("../../../../../common");
var _es_agg_source_schemas = require("./es_agg_source_schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ESJoinSourceSchema = exports.ESJoinSourceSchema = _es_agg_source_schemas.BaseESAggSourceSchema.extends({
  type: _configSchema.schema.string(),
  whereQuery: _configSchema.schema.maybe(_esQueryServer.querySchema)
});
const ESDistanceSourceSchema = exports.ESDistanceSourceSchema = ESJoinSourceSchema.extends({
  distance: _configSchema.schema.number(),
  geoField: _configSchema.schema.string(),
  type: _configSchema.schema.literal(_common.SOURCE_TYPES.ES_DISTANCE_SOURCE)
}, {
  unknowns: 'forbid'
});
const ESTermSourceSchema = exports.ESTermSourceSchema = ESJoinSourceSchema.extends({
  size: _configSchema.schema.maybe(_configSchema.schema.number({
    min: 1
  })),
  term: _configSchema.schema.string(),
  type: _configSchema.schema.literal(_common.SOURCE_TYPES.ES_TERM_SOURCE)
}, {
  unknowns: 'forbid'
});
const joinSourceSchema = exports.joinSourceSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  id: _configSchema.schema.string(),
  type: _configSchema.schema.string()
}, {
  unknowns: 'allow'
}), ESDistanceSourceSchema, ESTermSourceSchema]);