"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExpressionFunction = void 0;
var _i18n = require("@kbn/i18n");
var _visualizationsCommon = require("@kbn/visualizations-common");
var _expression_renderer = require("./expression_renderer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getExpressionFunction = () => ({
  name: 'lens_choropleth_chart',
  type: 'render',
  help: 'A choropleth chart. Metrics are joined to vector features to compare values across political boundaries',
  args: {
    title: {
      types: ['string'],
      help: ''
    },
    description: {
      types: ['string'],
      help: ''
    },
    layerId: {
      types: ['string'],
      help: ''
    },
    emsField: {
      types: ['string'],
      help: 'Elastic Map Service boundaries layer field provides the vector feature join key'
    },
    emsLayerId: {
      types: ['string'],
      help: 'Elastic Map Service boundaries layer id that provides vector features'
    },
    regionAccessor: {
      types: ['string'],
      help: 'Bucket accessor identifies the region key column'
    },
    valueAccessor: {
      types: ['string'],
      help: 'Value accessor identifies the value column'
    }
  },
  inputTypes: ['datatable'],
  fn(data, args, handlers) {
    var _handlers$inspectorAd;
    if (handlers !== null && handlers !== void 0 && (_handlers$inspectorAd = handlers.inspectorAdapters) !== null && _handlers$inspectorAd !== void 0 && _handlers$inspectorAd.tables) {
      handlers.inspectorAdapters.tables.reset();
      handlers.inspectorAdapters.tables.allowCsvExport = true;
      const logTable = (0, _visualizationsCommon.prepareLogTable)(data, [[args.valueAccessor ? [args.valueAccessor] : undefined, _i18n.i18n.translate('xpack.maps.logDatatable.value', {
        defaultMessage: 'Value'
      })], [args.regionAccessor ? [args.regionAccessor] : undefined, _i18n.i18n.translate('xpack.maps.logDatatable.region', {
        defaultMessage: 'Region key'
      })]], true);
      handlers.inspectorAdapters.tables.logDatatable('default', logTable);
    }
    return {
      type: 'render',
      as: _expression_renderer.RENDERER_ID,
      value: {
        data,
        args
      }
    };
  }
});
exports.getExpressionFunction = getExpressionFunction;