"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimesliderToggleButton = TimesliderToggleButton;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/toolbar_overlay/timeslider_toggle_button/timeslider_toggle_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TimesliderToggleButton(props) {
  function onClick() {
    if (props.isTimesliderOpen) {
      props.closeTimeslider();
    } else {
      props.openTimeslider();
    }
  }
  const label = props.isTimesliderOpen ? _i18n.i18n.translate('xpack.maps.timesliderToggleButton.closeLabel', {
    defaultMessage: 'Close timeslider'
  }) : _i18n.i18n.translate('xpack.maps.timesliderToggleButton.openLabel', {
    defaultMessage: 'Open timeslider'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    className: "mapToolbarOverlay__button",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: (0, _classnames.default)({
      'mapToolbarOverlay__buttonIcon-empty': !props.isTimesliderOpen
    }),
    size: "s",
    onClick: onClick,
    "data-test-subj": "timesliderToggleButton",
    iconType: "timeslider",
    "aria-label": label,
    title: label,
    color: "text",
    isSelected: props.isTimesliderOpen,
    display: props.isTimesliderOpen ? 'fill' : 'empty',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }));
}