"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Timeslider = Timeslider;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _public = require("@kbn/controls-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/timeslider/timeslider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Timeslider({
  setTimeslice,
  timeRange,
  waitForTimesliceToLoad$
}) {
  const [dataLoading, setDataLoading] = (0, _react.useState)(false);
  const [api, setApi] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (!api) {
      return;
    }
    let canceled = false;
    const subscription = api.timeslice$.pipe((0, _rxjs.tap)(() => {
      if (!canceled) setDataLoading(true);
    }), (0, _rxjs.switchMap)(timeslice => {
      setTimeslice(timeslice === undefined ? undefined : {
        from: timeslice[0],
        to: timeslice[1]
      });
      return waitForTimesliceToLoad$;
    })).subscribe(() => {
      if (!canceled) setDataLoading(false);
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
      canceled = true;
    };
  }, [api, setTimeslice, waitForTimesliceToLoad$]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "mapTimeslider mapTimeslider--animation",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public.ControlGroupRenderer, {
    onApiAvailable: nextApi => {
      setApi(nextApi);
    },
    dataLoading: dataLoading,
    getCreationOptions: async (initialState, builder) => {
      builder.addTimeSliderControl(initialState);
      return {
        initialState
      };
    },
    timeRange: timeRange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }));
}