"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapFeatureTooltipRow = exports.FeatureProperties = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/unified-search-plugin/public");
var _trigger_utils = require("../../../../trigger_actions/trigger_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/mb_map/tooltip_control/features_tooltip/feature_properties.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const mapFeatureStyles = {
  wrapper: (0, _react2.css)({
    overflow: 'auto',
    maxHeight: 'calc(49vh - 64px)'
  }),
  table: (0, _react2.css)({
    width: '100%'
  })
};
class FeatureProperties extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_prevLayerId", '');
    (0, _defineProperty2.default)(this, "_prevFeatureId", '');
    (0, _defineProperty2.default)(this, "_prevMbProperties", void 0);
    (0, _defineProperty2.default)(this, "_tableRef", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)(this, "state", {
      properties: null,
      actions: [],
      loadPropertiesErrorMsg: null,
      prevWidth: null,
      prevHeight: null
    });
    (0, _defineProperty2.default)(this, "_loadProperties", async () => {
      this._fetchProperties({
        nextFeatureId: this.props.featureId,
        nextLayerId: this.props.layerId,
        mbProperties: this.props.mbProperties
      });
    });
    (0, _defineProperty2.default)(this, "_showFilterActions", (tooltipProperty, getActionContext, addFilters) => {
      this.props.showFilterActions(this._renderFilterActions(tooltipProperty, getActionContext, addFilters));
    });
    (0, _defineProperty2.default)(this, "_fetchProperties", async ({
      nextLayerId,
      nextFeatureId,
      mbProperties
    }) => {
      if (this._prevLayerId === nextLayerId && this._prevFeatureId === nextFeatureId && _lodash.default.isEqual(this._prevMbProperties, mbProperties)) {
        // do not reload same feature properties
        return;
      }
      this._prevLayerId = nextLayerId;
      this._prevFeatureId = nextFeatureId;
      this._prevMbProperties = mbProperties;
      this.setState({
        properties: null,
        loadPropertiesErrorMsg: null
      });

      // Preserve current properties width/height so they can be used while rendering loading indicator.
      if (this.state.properties && this._tableRef.current) {
        this.setState({
          prevWidth: this._tableRef.current.clientWidth,
          prevHeight: this._tableRef.current.clientHeight
        });
      }
      let properties;
      try {
        properties = await this.props.loadFeatureProperties({
          layerId: nextLayerId,
          properties: mbProperties
        });
      } catch (error) {
        if (this._isMounted) {
          this.setState({
            properties: [],
            loadPropertiesErrorMsg: error.message
          });
        }
        return;
      }
      if (this._prevLayerId !== nextLayerId && this._prevFeatureId !== nextFeatureId) {
        // ignore results for old request
        return;
      }
      if (this._isMounted) {
        this.setState({
          properties
        });
      }
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadProperties();
    this._loadActions();
  }
  componentDidUpdate() {
    this._loadProperties();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadActions() {
    if (!this.props.getFilterActions) {
      return;
    }
    const actions = await this.props.getFilterActions();
    if (this._isMounted) {
      this.setState({
        actions
      });
    }
  }
  _renderFilterActions(tooltipProperty, getActionContext, addFilters) {
    const panel = {
      id: 0,
      items: this.state.actions.filter(action => {
        if ((0, _trigger_utils.isUrlDrilldown)(action)) {
          return !!this.props.onSingleValueTrigger;
        }
        return true;
      }).map(action => {
        const actionContext = getActionContext();
        const iconType = action.getIconType(actionContext);
        const name = action.getDisplayName(actionContext);
        return {
          name: name ? name : action.id,
          icon: iconType ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: iconType,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 206,
              columnNumber: 30
            }
          }) : undefined,
          onClick: async () => {
            this.props.onCloseTooltip();
            if ((0, _trigger_utils.isUrlDrilldown)(action)) {
              this.props.onSingleValueTrigger(action.id, tooltipProperty.getPropertyKey(), tooltipProperty.getRawValue());
            } else {
              const filters = await tooltipProperty.getESFilters();
              addFilters(filters, action.id);
            }
          },
          ['data-test-subj']: `mapFilterActionButton__${name}`
        };
      })
    };
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("table", {
      css: mapFeatureStyles.table,
      className: "eui-yScrollWithShadows",
      ref: this._tableRef,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("tbody", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(MapFeatureTooltipRow, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("td", {
      className: "mapFeatureTooltip__propertyLabel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 15
      }
    }, tooltipProperty.getPropertyName()), /*#__PURE__*/_react.default.createElement("td", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 15
      }
    }, tooltipProperty.getHtmlDisplayValue())))), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      initialPanelId: 0,
      panels: [panel],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 9
      }
    }));
  }
  _renderFilterCell(tooltipProperty) {
    if (!this.props.showFilterButtons || !tooltipProperty.isFilterable() || this.props.addFilters === undefined) {
      return /*#__PURE__*/_react.default.createElement("td", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 249,
          columnNumber: 14
        }
      });
    }
    const applyFilterButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      title: _i18n.i18n.translate('xpack.maps.tooltip.filterOnPropertyTitle', {
        defaultMessage: 'Filter on property'
      }),
      onClick: async () => {
        this.props.onCloseTooltip();
        const filters = await tooltipProperty.getESFilters();
        this.props.addFilters(filters, _public.ACTION_GLOBAL_APPLY_FILTER);
      },
      "aria-label": _i18n.i18n.translate('xpack.maps.tooltip.filterOnPropertyAriaLabel', {
        defaultMessage: 'Filter on property'
      }),
      "data-test-subj": "mapTooltipCreateFilterButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "filter",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 9
      }
    }));
    return this.props.getActionContext === undefined || this.state.actions.length === 0 || this.state.actions.length === 1 && this.state.actions[0].id === _public.ACTION_GLOBAL_APPLY_FILTER ? /*#__PURE__*/_react.default.createElement("td", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 7
      }
    }, applyFilterButton) : /*#__PURE__*/_react.default.createElement("td", {
      className: "mapFeatureTooltip_actionsRow",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 9
      }
    }, applyFilterButton, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      title: _i18n.i18n.translate('xpack.maps.tooltip.viewActionsTitle', {
        defaultMessage: 'View filter actions'
      }),
      onClick: () => {
        this._showFilterActions(tooltipProperty, this.props.getActionContext, this.props.addFilters);
      },
      "aria-label": _i18n.i18n.translate('xpack.maps.tooltip.viewActionsTitle', {
        defaultMessage: 'View filter actions'
      }),
      "data-test-subj": "mapTooltipMoreActionsButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "arrowRight",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 13
      }
    }))));
  }
  render() {
    if (this.state.loadPropertiesErrorMsg) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        announceOnMount: true,
        title: _i18n.i18n.translate('xpack.maps.tooltip.unableToLoadContentTitle', {
          defaultMessage: 'Unable to load tooltip content'
        }),
        color: "danger",
        iconType: "warning",
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 308,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 317,
          columnNumber: 11
        }
      }, this.state.loadPropertiesErrorMsg));
    }
    if (!this.state.properties) {
      const loadingMsg = _i18n.i18n.translate('xpack.maps.tooltip.loadingMsg', {
        defaultMessage: 'Loading'
      });
      // Use width/height of last viewed properties while displaying loading status
      // to avoid resizing component during loading phase and bouncing tooltip container around
      const style = {};
      if (this.state.prevWidth && this.state.prevHeight) {
        style.width = this.state.prevWidth;
        style.height = this.state.prevHeight;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
        textAlign: "center",
        style: style,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 334,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 335,
          columnNumber: 11
        }
      }), loadingMsg);
    }
    const rows = this.state.properties.map(tooltipProperty => {
      return /*#__PURE__*/_react.default.createElement(MapFeatureTooltipRow, {
        key: tooltipProperty.getPropertyKey(),
        className: "mapFeatureTooltip_row",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 343,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("td", {
        className: "mapFeatureTooltip__propertyLabel",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 347,
          columnNumber: 11
        }
      }, tooltipProperty.getPropertyName()), /*#__PURE__*/_react.default.createElement("td", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 348,
          columnNumber: 11
        }
      }, tooltipProperty.getHtmlDisplayValue()), this._renderFilterCell(tooltipProperty));
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      css: mapFeatureStyles.wrapper,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 355,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("table", {
      css: mapFeatureStyles.table,
      className: "eui-yScrollWithShadows",
      ref: this._tableRef,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 356,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("tbody", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 357,
        columnNumber: 11
      }
    }, rows)));
  }
}
exports.FeatureProperties = FeatureProperties;
const componentStyles = {
  mapFeatureTooltipRowStyles: ({
    euiTheme
  }) => (0, _react2.css)({
    '&.mapFeatureTooltip_row': {
      borderBottom: `1px solid ${euiTheme.colors.lightestShade}`
    },
    '.mapFeatureTooltip__propertyLabel': {
      minWidth: `${parseFloat(euiTheme.size.xl) * 2.5}px`,
      maxWidth: `${parseFloat(euiTheme.size.xl) * 4}px`,
      fontWeight: euiTheme.font.weight.bold
    },
    '.mapFeatureTooltip_actionsRow > span': {
      display: 'flex',
      justifyContent: 'flex-end'
    },
    td: {
      overflowWrap: 'break-word',
      wordBreak: 'break-word',
      padding: euiTheme.size.xs
    }
  })
};
const MapFeatureTooltipRow = ({
  children,
  className
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  return /*#__PURE__*/_react.default.createElement("tr", {
    css: styles.mapFeatureTooltipRowStyles,
    className: className,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 393,
      columnNumber: 5
    }
  }, children);
};
exports.MapFeatureTooltipRow = MapFeatureTooltipRow;