"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TooltipProperty = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TooltipProperty {
  constructor(propertyKey, propertyName, rawValue) {
    (0, _defineProperty2.default)(this, "_propertyKey", void 0);
    (0, _defineProperty2.default)(this, "_rawValue", void 0);
    (0, _defineProperty2.default)(this, "_propertyName", void 0);
    this._propertyKey = propertyKey;
    this._propertyName = propertyName;
    this._rawValue = rawValue;
  }
  getPropertyKey() {
    return this._propertyKey;
  }
  getPropertyName() {
    return this._propertyName;
  }
  getHtmlDisplayValue() {
    return _lodash.default.escape(Array.isArray(this._rawValue) ? this._rawValue.join() : this._rawValue);
  }
  getRawValue() {
    return this._rawValue;
  }
  isFilterable() {
    return false;
  }
  async getESFilters() {
    return [];
  }
}
exports.TooltipProperty = TooltipProperty;