"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDistanceJoinLayerDescriptor = createDistanceJoinLayerDescriptor;
var _uuid = require("uuid");
var _constants = require("../../../../../../common/constants");
var _get_agg_key = require("../../../../../../common/get_agg_key");
var _vector_style = require("../../../../styles/vector/vector_style");
var _vector_layer = require("../../../vector_layer");
var _es_search_source = require("../../../../sources/es_search_source");
var _vector_style_defaults = require("../../../../styles/vector/vector_style_defaults");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-ignore

const defaultDynamicProperties = (0, _vector_style_defaults.getDefaultDynamicProperties)();
function createDistanceJoinLayerDescriptor({
  distance,
  leftDataViewId,
  leftGeoField,
  rightDataViewId,
  rightGeoField
}) {
  const metricsDescriptor = {
    type: _constants.AGG_TYPE.COUNT
  };
  const joinId = (0, _uuid.v4)();
  const countJoinFieldName = (0, _get_agg_key.getJoinAggKey)({
    aggType: metricsDescriptor.type,
    rightSourceId: joinId
  });
  const styleProperties = {
    [_constants.VECTOR_STYLES.LABEL_TEXT]: {
      type: _constants.STYLE_TYPE.DYNAMIC,
      options: {
        ...defaultDynamicProperties[_constants.VECTOR_STYLES.LABEL_TEXT].options,
        field: {
          name: countJoinFieldName,
          origin: _constants.FIELD_ORIGIN.JOIN
        }
      }
    }
  };
  const joins = [{
    leftField: '_id',
    right: {
      type: _constants.SOURCE_TYPES.ES_DISTANCE_SOURCE,
      id: joinId,
      indexPatternId: rightDataViewId,
      metrics: [metricsDescriptor],
      distance,
      geoField: rightGeoField,
      applyGlobalQuery: true,
      applyGlobalTime: true,
      applyForceRefresh: true
    }
  }];
  return _vector_layer.GeoJsonVectorLayer.createDescriptor({
    joins,
    sourceDescriptor: _es_search_source.ESSearchSource.createDescriptor({
      indexPatternId: leftDataViewId,
      geoField: leftGeoField,
      scalingType: _constants.SCALING_TYPES.LIMIT,
      applyGlobalQuery: true,
      applyGlobalTime: true,
      applyForceRefresh: true
    }),
    style: _vector_style.VectorStyle.createDescriptor(styleProperties)
  });
}