"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformMapAttributesIn = transformMapAttributesIn;
var _references = require("../migrations/references");
var _stored_map_attributes = require("./stored_map_attributes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function transformMapAttributesIn(mapState) {
  const storedMapAttributes = {
    title: mapState.title
  };
  if (mapState.description) storedMapAttributes.description = mapState.description;
  if (mapState.layers) storedMapAttributes.layerListJSON = JSON.stringify(mapState.layers);
  const mapStateJSON = getJSONString({
    ...mapState,
    ...(mapState.refreshInterval ? {
      refreshConfig: {
        isPaused: mapState.refreshInterval.pause,
        interval: mapState.refreshInterval.value
      }
    } : {})
  }, _stored_map_attributes.mapStateKeys);
  if (mapStateJSON) storedMapAttributes.mapStateJSON = mapStateJSON;
  const uiStateJSON = getJSONString(mapState, _stored_map_attributes.uiStateKeys);
  if (uiStateJSON) storedMapAttributes.uiStateJSON = uiStateJSON;
  return (0, _references.extractReferences)({
    attributes: storedMapAttributes
  });
}
function getJSONString(mapState, keys) {
  const selectedState = {};
  keys.forEach(key => {
    if (key in mapState) {
      selectedState[key] = mapState[key];
    }
  });
  return Object.keys(selectedState).length ? JSON.stringify(selectedState) : undefined;
}