"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementLandingPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _managementCardsNavigation = require("@kbn/management-cards-navigation");
var _autoopsPromotionCallout = require("@kbn/autoops-promotion-callout");
var _management_context = require("../management_app/management_context");
var _classic_empty_prompt = require("./classic_empty_prompt");
var _solution_empty_prompt = require("./solution_empty_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/management/public/components/landing/landing.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ManagementLandingPage = ({
  setBreadcrumbs,
  onAppMounted
}) => {
  var _coreStart$applicatio, _coreStart$applicatio2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    appBasePath,
    sections,
    kibanaVersion,
    cardsNavigationConfig,
    chromeStyle,
    coreStart,
    cloud,
    hasEnterpriseLicense
  } = (0, _management_context.useAppContext)();
  setBreadcrumbs();

  // Check if cloud services are available
  const isCloudEnabled = (cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled) || false;
  // AutoOps promotion callout should only be shown for self-managed instances with an enterprise license
  const shouldShowAutoOpsPromotion = !isCloudEnabled && hasEnterpriseLicense;
  const learnMoreLink = coreStart.docLinks.links.cloud.connectToAutoops;
  const cloudConnectUrl = coreStart.application.getUrlForApp('cloud_connect');
  const handleConnectClick = e => {
    e.preventDefault();
    coreStart.application.navigateToApp('cloud_connect');
  };
  const hasCloudConnectPermission = Boolean(((_coreStart$applicatio = coreStart.application.capabilities.cloudConnect) === null || _coreStart$applicatio === void 0 ? void 0 : _coreStart$applicatio.show) || ((_coreStart$applicatio2 = coreStart.application.capabilities.cloudConnect) === null || _coreStart$applicatio2 === void 0 ? void 0 : _coreStart$applicatio2.configure));
  (0, _react.useEffect)(() => {
    onAppMounted('');
  }, [onAppMounted]);
  if (cardsNavigationConfig !== null && cardsNavigationConfig !== void 0 && cardsNavigationConfig.enabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      restrictWidth: true,
      "data-test-subj": "cards-navigation-page",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_managementCardsNavigation.CardsNavigation, {
      sections: sections,
      appBasePath: appBasePath,
      hideLinksTo: cardsNavigationConfig === null || cardsNavigationConfig === void 0 ? void 0 : cardsNavigationConfig.hideLinksTo,
      extendedCardNavigationDefinitions: cardsNavigationConfig === null || cardsNavigationConfig === void 0 ? void 0 : cardsNavigationConfig.extendCardNavDefinitions,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 9
      }
    }));
  }
  if (!chromeStyle) return null;
  if (chromeStyle === 'project') {
    return /*#__PURE__*/_react.default.createElement(_solution_empty_prompt.SolutionEmptyPrompt, {
      kibanaVersion: kibanaVersion,
      coreStart: coreStart,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, shouldShowAutoOpsPromotion && /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                max-width: 600px;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_autoopsPromotionCallout.AutoOpsPromotionCallout, {
    learnMoreLink: learnMoreLink,
    cloudConnectUrl: cloudConnectUrl,
    onConnectClick: handleConnectClick,
    hasCloudConnectPermission: hasCloudConnectPermission,
    overrideCalloutProps: {
      style: {
        margin: `0 ${euiTheme.size.l}`
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_classic_empty_prompt.ClassicEmptyPrompt, {
    kibanaVersion: kibanaVersion,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }))));
};
exports.ManagementLandingPage = ManagementLandingPage;