"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.maintenanceWindowFeature = void 0;
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maintenanceWindowFeature = exports.maintenanceWindowFeature = {
  id: _common.MAINTENANCE_WINDOW_FEATURE_ID,
  name: _i18n.i18n.translate('xpack.maintenance_windows.feature.maintenanceWindowFeatureName', {
    defaultMessage: 'Maintenance Windows'
  }),
  category: _server.DEFAULT_APP_CATEGORIES.management,
  app: [],
  management: {
    insightsAndAlerting: ['maintenanceWindows']
  },
  privileges: {
    all: {
      app: [],
      api: [_common.MAINTENANCE_WINDOW_API_PRIVILEGES.READ_MAINTENANCE_WINDOW, _common.MAINTENANCE_WINDOW_API_PRIVILEGES.WRITE_MAINTENANCE_WINDOW],
      management: {
        insightsAndAlerting: ['maintenanceWindows']
      },
      savedObject: {
        all: [_common.MAINTENANCE_WINDOW_SAVED_OBJECT_TYPE],
        read: []
      },
      ui: ['show', 'save']
    },
    read: {
      app: [],
      api: [_common.MAINTENANCE_WINDOW_API_PRIVILEGES.READ_MAINTENANCE_WINDOW],
      management: {
        insightsAndAlerting: ['maintenanceWindows']
      },
      savedObject: {
        all: [],
        read: [_common.MAINTENANCE_WINDOW_SAVED_OBJECT_TYPE]
      },
      ui: ['show']
    }
  }
};