"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  savedObjects: _configSchema.schema.object({
    logView: _configSchema.schema.object({
      enabled: (0, _configSchema.offeringBasedSchema)({
        serverless: _configSchema.schema.boolean({
          defaultValue: false
        }),
        options: {
          defaultValue: true
        }
      })
    })
  })
});
const config = exports.config = {
  schema: configSchema,
  deprecations: ({
    unused
  }) => [unused('savedObjects.logView.enabled', {
    level: 'warning'
  })]
};