"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogEntry = void 0;
var _react = require("react");
var _runtime_types = require("../../../common/runtime_types");
var _log_entry = require("../../../common/search_strategies/log_entries/log_entry");
var _data_search = require("../../utils/data_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogEntry = ({
  logViewReference,
  logEntryId
}) => {
  const {
    search: fetchLogEntry,
    requests$: logEntrySearchRequests$
  } = (0, _data_search.useDataSearch)({
    getRequest: (0, _react.useCallback)(() => {
      return !!logEntryId && !!logViewReference ? {
        request: {
          params: _log_entry.logEntrySearchRequestParamsRT.encode({
            logView: logViewReference,
            logEntryId
          })
        },
        options: {
          strategy: _log_entry.LOG_ENTRY_SEARCH_STRATEGY
        }
      } : null;
    }, [logViewReference, logEntryId]),
    parseResponses: parseLogEntrySearchResponses
  });
  const {
    cancelRequest,
    isRequestRunning,
    isResponsePartial,
    latestResponseData,
    latestResponseErrors,
    loaded,
    total
  } = (0, _data_search.useLatestPartialDataSearchResponse)(logEntrySearchRequests$);
  return {
    cancelRequest,
    errors: latestResponseErrors,
    fetchLogEntry,
    isRequestRunning,
    isResponsePartial,
    loaded,
    logEntry: latestResponseData !== null && latestResponseData !== void 0 ? latestResponseData : null,
    total
  };
};
exports.useLogEntry = useLogEntry;
const parseLogEntrySearchResponses = (0, _data_search.normalizeDataSearchResponses)(null, (0, _runtime_types.decodeOrThrow)(_log_entry.logEntrySearchResponsePayloadRT));