"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.summaryExceptionListRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _zodHelpers = require("@kbn/zod-helpers");
var _api = require("@kbn/securitysolution-exceptions-common/api");
var _constants = require("@kbn/security-solution-features/constants");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const summaryExceptionListRoute = router => {
  router.versioned.get({
    access: 'public',
    path: `${_securitysolutionListConstants.EXCEPTION_LIST_URL}/summary`,
    security: {
      authz: {
        requiredPrivileges: [_constants.LISTS_API_SUMMARY]
      }
    }
  }).addVersion({
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_api.ReadExceptionListSummaryRequestQuery)
      }
    },
    version: '2023-10-31'
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const {
        id,
        list_id: listId,
        namespace_type: namespaceType,
        filter
      } = request.query;
      const exceptionLists = await (0, _utils.getExceptionListClient)(context);
      if (id == null && listId == null) {
        return siemResponse.error({
          body: 'id or list_id required',
          statusCode: 400
        });
      }
      const exceptionListSummary = await exceptionLists.getExceptionListSummary({
        filter,
        id,
        listId,
        namespaceType
      });
      if (exceptionListSummary == null) {
        return siemResponse.error({
          body: (0, _utils.getErrorMessageExceptionList)({
            id,
            listId
          }),
          statusCode: 404
        });
      }
      return response.ok({
        body: _api.ReadExceptionListSummaryResponse.parse(exceptionListSummary)
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.summaryExceptionListRoute = summaryExceptionListRoute;