"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findExceptionListRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _zodHelpers = require("@kbn/zod-helpers");
var _api = require("@kbn/securitysolution-exceptions-common/api");
var _constants = require("@kbn/security-solution-features/constants");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findExceptionListRoute = router => {
  router.versioned.get({
    access: 'public',
    path: `${_securitysolutionListConstants.EXCEPTION_LIST_URL}/_find`,
    security: {
      authz: {
        requiredPrivileges: [_constants.LISTS_API_READ]
      }
    }
  }).addVersion({
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_api.FindExceptionListsRequestQuery)
      }
    },
    version: '2023-10-31'
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const exceptionLists = await (0, _utils.getExceptionListClient)(context);
      const {
        filter,
        page,
        namespace_type: namespaceType,
        per_page: perPage,
        sort_field: sortField,
        sort_order: sortOrder
      } = request.query;
      const exceptionListItems = await exceptionLists.findExceptionList({
        filter,
        namespaceType,
        page,
        perPage,
        pit: undefined,
        searchAfter: undefined,
        sortField,
        sortOrder
      });
      return response.ok({
        body: _api.FindExceptionListsResponse.parse(exceptionListItems)
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.findExceptionListRoute = findExceptionListRoute;