"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.linksEmbeddableSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _presentationPublishingSchemas = require("@kbn/presentation-publishing-schemas");
var _cm_services = require("./content_management/schema/v1/cm_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Links by-value state schema (contains layout and links)
const linksByValueStateSchema = _configSchema.schema.object({
  layout: _cm_services.layoutSchema,
  links: _cm_services.linksArraySchema
});

// Links by-reference state schema (contains savedObjectId)
const linksByReferenceStateSchema = _configSchema.schema.object({
  savedObjectId: _configSchema.schema.string({
    meta: {
      description: 'The ID of the saved links object'
    }
  })
});

// Links by-value embeddable schema (by-value state + titles)
const linksByValueEmbeddableSchema = _configSchema.schema.allOf([linksByValueStateSchema, _presentationPublishingSchemas.serializedTitlesSchema], {
  meta: {
    description: 'Links by-value embeddable schema'
  }
});

// Links by-reference embeddable schema (by-reference state + titles)
const linksByReferenceEmbeddableSchema = _configSchema.schema.allOf([linksByReferenceStateSchema, _presentationPublishingSchemas.serializedTitlesSchema], {
  meta: {
    description: 'Links by-reference embeddable schema'
  }
});

// Complete links embeddable schema (union of by-value and by-reference embeddables)
const linksEmbeddableSchema = exports.linksEmbeddableSchema = _configSchema.schema.oneOf([linksByValueEmbeddableSchema, linksByReferenceEmbeddableSchema], {
  meta: {
    description: 'Links embeddable schema'
  }
});