"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOptions = getOptions;
var _content_management = require("../../content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getOptions(type, options) {
  if (!options) return undefined;
  if (type === _content_management.DASHBOARD_LINK_TYPE) {
    const dashboardOptions = options;
    return {
      ...(typeof dashboardOptions.openInNewTab === 'boolean' && {
        openInNewTab: dashboardOptions.openInNewTab
      }),
      ...(typeof dashboardOptions.useCurrentFilters === 'boolean' && {
        useCurrentFilters: dashboardOptions.useCurrentFilters
      }),
      ...(typeof dashboardOptions.useCurrentDateRange === 'boolean' && {
        useCurrentDateRange: dashboardOptions.useCurrentDateRange
      })
    };
  }
  const urlOptions = options;
  return {
    ...(typeof urlOptions.openInNewTab === 'boolean' && {
      openInNewTab: urlOptions.openInNewTab
    }),
    ...(typeof urlOptions.encodeUrl === 'boolean' && {
      encodeUrl: urlOptions.encodeUrl
    })
  };
}