"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lensCreateResponseBodySchema = exports.lensCreateRequestQuerySchema = exports.lensCreateRequestParamsSchema = exports.lensCreateRequestBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _config_builder = require("@kbn/lens-embeddable-utils/config_builder");
var _content_management = require("../../../../content_management");
var _v = require("../../../../content_management/v0");
var _utils = require("../../../../utils");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const lensCreateRequestParamsSchema = exports.lensCreateRequestParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_content_management.lensItemSchema.getPropSchemas().id)
}, {
  unknowns: 'forbid'
});
const lensCreateRequestQuerySchema = exports.lensCreateRequestQuerySchema = _configSchema.schema.object({
  ...(0, _utils.pickFromObjectSchema)(_content_management.lensCMCreateOptionsSchema.getPropSchemas(), ['overwrite'])
}, {
  unknowns: 'forbid'
});
const lensCreateRequestBodySchema = exports.lensCreateRequestBodySchema = _configSchema.schema.oneOf([_config_builder.lensApiStateSchema, _content_management.lensItemDataSchema, _v.lensItemDataSchemaV0 // Temporarily permit passing old v0 SO attributes on create
]);
const lensCreateResponseBodySchema = exports.lensCreateResponseBodySchema = _common.lensResponseItemSchema;