"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLegacyURLConflictsMessage = getLegacyURLConflictsMessage;
exports.getSearchContextIncompatibleMessage = getSearchContextIncompatibleMessage;
exports.hasLegacyURLConflict = hasLegacyURLConflict;
exports.isSearchContextIncompatibleWithDataViews = isSearchContextIncompatibleWithDataViews;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../common/constants");
var _user_messages_ids = require("../../user_messages_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/react_embeddable/user_messages/checks.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function hasLegacyURLConflict(metaInfo, spaces) {
  var _spaces$ui, _spaces$ui$components;
  return (metaInfo === null || metaInfo === void 0 ? void 0 : metaInfo.outcome) === 'conflict' && (spaces === null || spaces === void 0 ? void 0 : (_spaces$ui = spaces.ui) === null || _spaces$ui === void 0 ? void 0 : (_spaces$ui$components = _spaces$ui.components) === null || _spaces$ui$components === void 0 ? void 0 : _spaces$ui$components.getEmbeddableLegacyUrlConflict);
}
function getLegacyURLConflictsMessage(metaInfo, spaces) {
  const LegacyURLConfig = spaces.ui.components.getEmbeddableLegacyUrlConflict;
  return {
    uniqueId: _user_messages_ids.URL_CONFLICT,
    severity: 'error',
    displayLocations: [{
      id: 'visualization'
    }],
    shortMessage: _i18n.i18n.translate('xpack.lens.legacyURLConflict.shortMessage', {
      defaultMessage: `You've encountered a URL conflict`
    }),
    longMessage: /*#__PURE__*/_react.default.createElement(LegacyURLConfig, {
      targetType: _constants.DOC_TYPE,
      sourceId: metaInfo.sourceId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 18
      }
    }),
    fixableInEditor: false
  };
}
function isSearchContextIncompatibleWithDataViews(api, context, searchContext, indexPatternRefs, indexPatterns) {
  return !api.isTextBasedLanguage() && searchContext.timeRange == null && indexPatternRefs.some(({
    id
  }) => {
    const indexPattern = indexPatterns[id];
    return (indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.timeFieldName) && indexPattern.getFieldByName(indexPattern.timeFieldName);
  });
}
function getSearchContextIncompatibleMessage() {
  return {
    uniqueId: _user_messages_ids.MISSING_TIME_RANGE_ON_EMBEDDABLE,
    severity: 'error',
    fixableInEditor: false,
    displayLocations: [{
      id: 'visualization'
    }],
    shortMessage: _i18n.i18n.translate('xpack.lens.missingTimeRangeParam.shortMessage', {
      defaultMessage: `Missing timeRange property`
    }),
    longMessage: _i18n.i18n.translate('xpack.lens.missingTimeRangeParam.longMessage', {
      defaultMessage: `The timeRange property is required for the given configuration`
    })
  };
}