"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeSearchContext = initializeSearchContext;
exports.searchContextComparators = void 0;
var _esQuery = require("@kbn/es-query");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _publishes_search_session = require("@kbn/presentation-publishing/interfaces/fetch/publishes_search_session");
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _esqlUtils = require("@kbn/esql-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const searchContextComparators = exports.searchContextComparators = {
  ..._presentationPublishing.timeRangeComparators,
  query: 'skip',
  filters: 'skip',
  timeslice: 'skip',
  searchSessionId: 'skip',
  lastReloadRequestTime: 'skip'
};
const getProjectRoutingOverrides = query => {
  if ((0, _esQuery.isOfAggregateQueryType)(query)) {
    const value = (0, _esqlUtils.getProjectRoutingFromEsqlQuery)(query.esql);
    return value ? [{
      value
    }] : undefined;
  }
};
function initializeSearchContext(initialState, internalApi, parentApi, {
  injectFilterReferences
}) {
  const searchSessionId$ = (0, _publishes_search_session.apiPublishesSearchSession)(parentApi) ? parentApi.searchSessionId$ : new _rxjs.BehaviorSubject(undefined);
  const attributes = internalApi.attributes$.getValue();
  const lastReloadRequestTime$ = new _rxjs.BehaviorSubject(undefined);

  // Make sure the panel access the filters with the correct references
  const filters$ = new _rxjs.BehaviorSubject(injectFilterReferences(attributes.state.filters, attributes.references));
  const query$ = new _rxjs.BehaviorSubject(attributes.state.query);
  const timeslice$ = new _rxjs.BehaviorSubject(undefined);
  const projectRoutingOverrides$ = new _rxjs.BehaviorSubject(getProjectRoutingOverrides(attributes.state.query));
  const timeRangeManager = (0, _presentationPublishing.initializeTimeRangeManager)(initialState);
  const subscriptions = [internalApi.attributes$.pipe((0, _rxjs.map)(attrs => attrs.state.query), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual)).subscribe(query$), internalApi.attributes$.pipe((0, _rxjs.map)(attrs => attrs.state.filters), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual)).subscribe(filters$), query$.pipe((0, _rxjs.map)(getProjectRoutingOverrides), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual)).subscribe(projectRoutingOverrides$)];
  return {
    api: {
      searchSessionId$,
      filters$,
      query$,
      timeslice$,
      projectRoutingOverrides$,
      isCompatibleWithUnifiedSearch: () => true,
      ...timeRangeManager.api
    },
    anyStateChange$: (0, _rxjs.merge)(timeRangeManager.anyStateChange$),
    cleanup: () => {
      subscriptions.forEach(sub => sub.unsubscribe());
    },
    getLatestState: () => ({
      searchSessionId: searchSessionId$.getValue(),
      filters: filters$.getValue(),
      query: query$.getValue(),
      timeslice: timeslice$.getValue(),
      lastReloadRequestTime: lastReloadRequestTime$.getValue(),
      ...timeRangeManager.getLatestState()
    }),
    reinitializeState: lastSaved => {
      timeRangeManager.reinitializeState(lastSaved);
    }
  };
}