"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExecutionSearchContext = getExecutionSearchContext;
exports.getMergedSearchContext = getMergedSearchContext;
var _esQuery = require("@kbn/es-query");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getMergedSearchContext({
  attributes
}, {
  filters,
  query,
  timeRange,
  esqlVariables,
  projectRouting
}, customTimeRange$, parentApi, {
  data,
  injectFilterReferences
}) {
  var _ref;
  const parentTimeSlice = (0, _presentationPublishing.apiPublishesTimeslice)(parentApi) ? parentApi.timeslice$.getValue() : undefined;
  const timesliceTimeRange = parentTimeSlice ? {
    from: new Date(parentTimeSlice[0]).toISOString(),
    to: new Date(parentTimeSlice[1]).toISOString(),
    mode: 'absolute'
  } : undefined;
  const customTimeRange = customTimeRange$.getValue();
  const timeRangeToRender = (_ref = customTimeRange !== null && customTimeRange !== void 0 ? customTimeRange : timesliceTimeRange) !== null && _ref !== void 0 ? _ref : timeRange;
  const context = {
    esqlVariables,
    now: data.nowProvider.get().getTime(),
    timeRange: timeRangeToRender,
    query: [attributes.state.query].filter(_utils.nonNullable),
    filters: injectFilterReferences(attributes.state.filters || [], attributes.references),
    disableWarningToasts: true,
    projectRouting
  };
  // Prepend query and filters from dashboard to the visualization ones
  if (query) {
    if (!(0, _esQuery.isOfAggregateQueryType)(query)) {
      context.query.unshift(query);
    }
  }
  if (filters) {
    context.filters.unshift(...filters.filter(({
      meta
    }) => !meta.disabled));
  }
  return context;
}
function getExecutionSearchContext(searchContext) {
  if (!(0, _esQuery.isOfAggregateQueryType)(searchContext.query[0])) {
    return searchContext;
  }
  return {
    ...searchContext,
    query: []
  };
}